(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    873279,      21076]
NotebookOptionsPosition[    848981,      20639]
NotebookOutlinePosition[    849451,      20656]
CellTagsIndexPosition[    849408,      20653]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Harmonic Quadrilaterals", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, 
   3.947147906503248*^9, {3.9471622861437607`*^9, 3.947162287750935*^9}, {
   3.947219502788477*^9, 
   3.9472195047086334`*^9}},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about harmonic \
quadrilaterals in the paper \"More Relationships between a Central \
Quadrilateral and its Reference Quadrilateral\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in \
February 2025.

This Notebook is Copyright \[Copyright] February 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947162294038662*^9, 3.947162295062664*^9}, {
  3.947219511916191*^9, 
  3.947219513852024*^9}},ExpressionUUID->"08758b0a-705f-b842-b1d6-\
6a28a79b6218"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.94550589477663*^9, 3.9455059090976067`*^9}, {
  3.947131190260437*^9, 
  3.947131192227951*^9}},ExpressionUUID->"5e4c6aa2-710c-4599-941e-\
5f13e499af78"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", ">", "0"}], ",", 
     RowBox[{"b", ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ptD", "=", 
  RowBox[{"SegundaInterseccionCircunferencia", "[", 
   RowBox[{"ptK", ",", 
    RowBox[{"{", 
     RowBox[{"ptB", ",", "ptA", ",", "ptC"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.945504565162958*^9, 3.94550458198252*^9}, {
   3.9455170892604294`*^9, 3.945517091156999*^9}, {3.946437513579389*^9, 
   3.946437514387348*^9}, {3.946437922994858*^9, 3.946437998083948*^9}, {
   3.947131229988783*^9, 3.9471312337408752`*^9}, {3.94713126947538*^9, 
   3.947131271053065*^9}, {3.9471314397563486`*^9, 3.947131528028438*^9}, {
   3.947131689741032*^9, 3.947131695924305*^9}, {3.947131733918829*^9, 
   3.947131775067988*^9}, 3.94713185451009*^9, {3.947132455427481*^9, 
   3.947132456035076*^9}, {3.947133799219084*^9, 3.947133799613205*^9}, {
   3.9471624606466045`*^9, 3.9471624614180145`*^9}, 3.947162515937668*^9, {
   3.947219631276331*^9, 3.947219641252655*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SuperscriptBox["a", "2"]}], ",", 
   SuperscriptBox["b", "2"], ",", 
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SuperscriptBox["c", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.9472196440223846`*^9, 3.9472199471998997`*^9, 
  3.9472652533982882`*^9, 3.9475686343656445`*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"42c15b27-92d0-4942-aecd-b7dd69cf0375"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Collect", "[", 
    RowBox[{"#", ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "q", ",", "r"}], "}"}]}], "]"}], "&"}], "/@", 
  RowBox[{"Cross", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "q", ",", "r"}], "}"}], ",", "ptD"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.946639751494454*^9, 3.946639760163742*^9}, {
  3.946639794388481*^9, 3.946639809124231*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"99b2e229-dd1e-9847-93a3-8109a1361668"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox["c", "2"], " ", "q"}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "r"}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["c", "2"], " ", "p"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "r"}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "p"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "q"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.946639761255417*^9, 3.946639810101906*^9, 
  3.9466416591026535`*^9, 3.946643027600281*^9, 3.946746609130354*^9, 
  3.947219690268631*^9, 3.947219947219845*^9, 3.947265253780269*^9, 
  3.9475686347047367`*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"01536e20-67b0-d643-8c30-057499f5e6db"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixRank", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], "+", 
       SuperscriptBox["c", "2"]}], ",", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], "+", 
       SuperscriptBox["c", "2"]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ",", "0", ",", 
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ",", 
      SuperscriptBox["a", "2"], ",", "0"}], "}"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.946639780374342*^9, 3.946639783003608*^9}, {
  3.9466398188596497`*^9, 3.9466398860621433`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"a61c9d71-2293-2546-a38b-c7fff8eb7467"],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{{3.9466398694530287`*^9, 3.946639886772257*^9}, 
   3.9466416591056423`*^9, 3.946643029743159*^9, 3.946746609141325*^9, 
   3.9472196918116474`*^9, 3.947219947225828*^9, 3.9472652537862473`*^9, 
   3.947568634712717*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"82f4d30f-3642-2a44-9093-4235a98ff281"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "condition", " ", "for", " ", "ABCD", " ", "to", " ", "be", " ", 
    "harmonic", " ", "when", " ", "D", 
    RowBox[{"(", 
     RowBox[{"p", ":", "q", ":", "r"}], ")"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"harmonic", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["c", "2"], " ", "p"}], "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", "r"}]}], "==", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["b", "2"], " ", "p"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", "q"}]}], "==", "0"}]}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.9466399123657722`*^9, 3.946639944964231*^9}, {
   3.946640377219242*^9, 3.946640378915327*^9}, {3.9466430482956543`*^9, 
   3.946643064223556*^9}, {3.9466431435235763`*^9, 3.946643146127687*^9}, {
   3.947219703635725*^9, 3.947219722916189*^9}, 3.947219777751623*^9},
 CellLabel->"In[6]:=",ExpressionUUID->"7ed74a17-e41b-bd47-b883-c0a2d1fa3802"]
}, Closed]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"cf60f297-bbcd-8748-b453-\
e7118b4e0a98"],

Cell[CellGroupData[{

Cell["QAP centers", "Subsection",
 CellChangeTimes->{{3.945853740709931*^9, 3.945853743438184*^9}, {
  3.9464394595455627`*^9, 
  3.9464394652171745`*^9}},ExpressionUUID->"c8cca55e-04f1-8f4a-b670-\
3c3179eed91e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP", "=", 
   RowBox[{"<|", 
    RowBox[{
     RowBox[{"1", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ",", 
        RowBox[{"p", "+", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ",", 
        RowBox[{"p", "+", "q", "+", 
         RowBox[{"2", " ", "r"}]}]}], "}"}]}], ",", 
     RowBox[{"2", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", "SB"}], "-", 
           RowBox[{"r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "SA"}], "+", 
           RowBox[{"r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "SA"}], "-", 
           RowBox[{"q", " ", "SB"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"3", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}]}], 
          ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", 
              RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"4", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", "SA"}], "-", 
           RowBox[{"2", " ", "p", " ", "q", " ", "SA"}], "-", 
           RowBox[{"2", " ", "p", " ", "r", " ", "SA"}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}]}], ")"}]}],
         ",", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p"}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q"}], "-", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}], 
             ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"5", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"6", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"q", " ", 
                SuperscriptBox["SB", "2"]}], "-", 
               RowBox[{"r", " ", 
                SuperscriptBox["SC", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"p", " ", 
                SuperscriptBox["SA", "2"]}], "-", 
               RowBox[{"r", " ", 
                SuperscriptBox["SC", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"p", " ", 
                SuperscriptBox["SA", "2"]}], "-", 
               RowBox[{"q", " ", 
                SuperscriptBox["SB", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"7", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SB", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 SuperscriptBox["SB", "2"], "+", 
                 RowBox[{"2", " ", "SB", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"2", " ", "SB", " ", "SC"}], "+", 
                 SuperscriptBox["SC", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"3", " ", "r", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"r", " ", "SC", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "SA"}], "+", "SC"}], ")"}]}], "+", 
              RowBox[{"p", " ", "SA", " ", 
               RowBox[{"(", 
                RowBox[{"SA", "+", 
                 RowBox[{"2", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SA", " ", "SC"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"3", " ", "q", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"q", " ", "SB", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "SA"}], "+", "SB"}], ")"}]}], "+", 
              RowBox[{"p", " ", "SA", " ", 
               RowBox[{"(", 
                RowBox[{"SA", "+", 
                 RowBox[{"2", " ", "SB"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SA", " ", "SB"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}],
        "}"}]}], ",", 
     RowBox[{"8", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "p"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "p"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "q"}], "+", 
            RowBox[{"4", " ", "r", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}]}], "}"}]}],
      ",", 
     RowBox[{"9", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p", " ", "q"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"]}], "+", 
                 RowBox[{"3", " ", "p", " ", "r"}], "+", 
                 RowBox[{"q", " ", "r"}], "-", 
                 SuperscriptBox["r", "2"]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "p", " ", "q"}], "-", 
                 SuperscriptBox["q", "2"], "+", 
                 RowBox[{"2", " ", "p", " ", "r"}], "+", 
                 RowBox[{"q", " ", "r"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "q"}], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"4", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "q"}], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "-", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"5", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"3", " ", "p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "8"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "8"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", 
                 RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"p", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
              "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"p", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"8", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"4", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["c", "6"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["p", "2"]}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "q", " ", 
                  SuperscriptBox["r", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"12", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"9", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["q", "3"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"12", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"13", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "r"}], "-", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["p", "2"], "-", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "6"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "q", " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"5", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "-", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["q", "2"], " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "3"}], " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  SuperscriptBox["q", "3"], " ", "r"}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  SuperscriptBox["r", "3"]}], "+", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["p", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"8", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "3"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"12", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["c", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["q", "2"]}]}], ")"}], " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "r"}], "-", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "6"]}], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["p", "2"]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["q", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"5", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "-", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["q", "2"], " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"8", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"6", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "3"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    RowBox[{"2", " ", "q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"12", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"13", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"9", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"10", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"11", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"12", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
          ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", "q", " ", "SB"}], "+", 
           RowBox[{"p", " ", "r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{"p", " ", "q", " ", "SA"}], "+", 
           RowBox[{"q", " ", "r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r", " ", "SA"}], "+", 
           RowBox[{"q", " ", "r", " ", "SB"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", "q", " ", 
            SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"13", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"14", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "r"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"5", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"2", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"2", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}]}], "}"}]}], 
     ",", 
     RowBox[{"15", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"q", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["q", "2"]}], "+", 
               RowBox[{"5", " ", "q", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"5", " ", "q", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["p", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["q", "2"]}], "+", 
               RowBox[{"22", " ", "q", " ", "r"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "p"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"5", " ", "p", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"5", " ", "p", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["q", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"22", " ", "p", " ", "r"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["q", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               SuperscriptBox["q", "2"]}], ")"}], " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "p"}], "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"5", " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"5", " ", "p", " ", "q"}], "+", 
               SuperscriptBox["q", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"5", " ", "p", " ", "q"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["q", "2"]}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"22", " ", "p", " ", "q"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["q", "2"]}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"10", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"16", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"17", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["q", "2"], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"18", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"19", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"20", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"21", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"22", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"23", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", "q", " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
         RowBox[{"p", " ", "q", " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
         RowBox[{"p", " ", "r", " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", "SB"}]}]}], "}"}]}], ",", 
     RowBox[{"24", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", "SB", " ", 
          "SC"}], "-", 
         RowBox[{"4", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "SC"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], ")"}], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", "SC"}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "SA", " ", 
          "SC"}], "-", 
         RowBox[{"4", " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "SC"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], ")"}], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", "SC"}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "SA", " ", 
          "SB"}], "-", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"25", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"2", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"26", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"5", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"5", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"5", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"27", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["p", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"], " ", "q"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"p", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{"q", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "3"]}], " ", "q"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           SuperscriptBox["q", "4"], "+", 
           RowBox[{
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"q", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["p", "3"], " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"2", " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           SuperscriptBox["r", "4"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"28", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "4"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["b", "2"], "-", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", "r"}]}], 
             ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "4"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["q", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "+", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", "r"}], "+", 
              RowBox[{
               SuperscriptBox["a", "4"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"3", " ", "q", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", 
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "+", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["a", "2"], "-", 
                   SuperscriptBox["b", "2"]}], ")"}], " ", "p", " ", "q"}], 
                "+", 
                RowBox[{
                 SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "4"], " ", "q", " ", "r"}]}], ")"}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"3", " ", "q", " ", "r"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
       "}"}]}], ",", 
     RowBox[{"29", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["a", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "3"], " ", "r"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["p", "2"]}], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"30", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "q"}], ")"}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "-", 
              RowBox[{"3", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "p"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"3", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "p"}], "+", "q"}], ")"}], " ", "r", 
            " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"3", " ", "q"}]}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
       "}"}]}], ",", 
     RowBox[{"31", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"32", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", "q", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}]}], "}"}]}],
      ",", 
     RowBox[{"33", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB", " ", 
             "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA", " ", 
             "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA", " ", 
             "SB"}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"34", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"4", " ", "q"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p"}], "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"35", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"15", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "3"], " ", "r"}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"5", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"15", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"12", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"5", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["p", "2"]}], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"15", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"15", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"12", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"36", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["c", "2"]}], " ", "q"}], "-", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "-", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q", " ", "r"}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
               RowBox[{
                SuperscriptBox["a", "4"], " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["b", "4"], " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["c", "2"]}], " ", "p"}], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "p"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "r"}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "4"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["c", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["b", "2"], " ", 
                SuperscriptBox["c", "2"], " ", "q", " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["b", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["c", "4"], " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "-", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "q"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}]}], ")"}]}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["b", "2"]}], " ", "p"}], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "4"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["c", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["a", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["c", "4"], " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "p"}], "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}]}], "}"}]}], ",", 
     RowBox[{"37", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"p", " ", "q", " ", "SB"}], "+", 
            RowBox[{"p", " ", "r", " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"p", " ", "q", " ", "SA"}], "+", 
            RowBox[{"q", " ", "r", " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r", " ", "SA"}], "+", 
            RowBox[{"q", " ", "r", " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"38", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["b", "2"]}], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "-", "q", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", "p"}], "+", "q", "+", "r"}], 
                ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", 
                 RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", 
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "q", "+", 
             RowBox[{"2", " ", "r"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "-", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "-", "q", "-", 
                   RowBox[{"2", " ", "r"}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "-", "q", "+", 
                   RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          ")"}]}]}], "}"}]}], ",", 
     RowBox[{"39", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["b", "2"], "-", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "-", "r"}], ")"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "+", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "p"}], "+", "r"}], ")"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               RowBox[{"2", " ", "p", " ", "r"}], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["a", "2"], "-", 
                 SuperscriptBox["b", "2"]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "q"}], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}]}], "}"}]}], ",", 
     RowBox[{"40", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], "+", 
            SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", 
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "p"}], "+", 
                   RowBox[{"2", " ", "q"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "q"}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["q", "2"]}]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", "p"}], "+", 
                  RowBox[{"2", " ", "q"}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "r", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", 
                  RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["p", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", "q"}], "+", 
                  RowBox[{"9", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["q", "2"]}], "+", 
                  RowBox[{"15", " ", "q", " ", "r"}], "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["a", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"9", " ", "p"}], "+", 
                  RowBox[{"7", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"12", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "r"}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "q"}], "+", 
                   RowBox[{"2", " ", "r"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["p", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", "q"}], "+", 
                  RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", 
                   SuperscriptBox["q", "2"]}], "+", 
                  RowBox[{"15", " ", "q", " ", "r"}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], "+", 
            SuperscriptBox["b", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", 
                  RowBox[{"2", " ", "q"}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "q"}], "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["q", "2"]}]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", "p"}], "+", 
                  RowBox[{"9", " ", "q"}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "p"}], "+", 
                   RowBox[{"3", " ", "r"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "p"}], "+", 
                  RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"6", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "r"}], "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"41", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "4"]}], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "4"]}], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"42", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q", " ", "r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "SB"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"43", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", "p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", "p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"44", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "q"}], "-", 
            RowBox[{"q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p", " ", "q"}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            SuperscriptBox["q", "3"], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            SuperscriptBox["r", "3"]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "3"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            SuperscriptBox["r", "3"]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "3"], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            SuperscriptBox["q", "3"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}]}], "|>"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945841589546528*^9, 3.945841604944151*^9}, {
   3.9458416486015606`*^9, 3.945841701130226*^9}, 3.94584180266897*^9, {
   3.945841855521532*^9, 3.945841865133842*^9}, {3.9458419743855267`*^9, 
   3.94584197851943*^9}, {3.945842012120521*^9, 3.945842016064451*^9}, {
   3.945842114756489*^9, 3.945842119338508*^9}, {3.945842170028664*^9, 
   3.945842174123476*^9}, {3.945842254968681*^9, 3.9458422593104534`*^9}, {
   3.94584246069957*^9, 3.945842465998068*^9}, {3.945842501032144*^9, 
   3.9458425325383263`*^9}, {3.945842735167492*^9, 3.945842742091593*^9}, {
   3.945842846919035*^9, 3.945842850061655*^9}, {3.945842936494915*^9, 
   3.945842969633366*^9}, {3.945843125849571*^9, 3.94584313274209*^9}, {
   3.945843174894972*^9, 3.945843178277809*^9}, {3.9458432197775517`*^9, 
   3.9458432370243473`*^9}, {3.945843287330616*^9, 3.9458432907977543`*^9}, {
   3.945843326923149*^9, 3.9458433430906563`*^9}, {3.945843384493232*^9, 
   3.945843387811741*^9}, {3.945843423557177*^9, 3.945843427076299*^9}, {
   3.9458460856414566`*^9, 3.9458460903603935`*^9}, {3.9458461244501*^9, 
   3.945846127392929*^9}, {3.945846273464027*^9, 3.945846279270181*^9}, {
   3.945846311960058*^9, 3.945846315350111*^9}, {3.945846366817175*^9, 
   3.945846382831234*^9}, {3.945846756353731*^9, 3.9458467662170296`*^9}, {
   3.945846811099188*^9, 3.945846841686339*^9}, {3.945846884211832*^9, 
   3.945847260236458*^9}, {3.945847371762398*^9, 3.9458473779483223`*^9}, {
   3.945847468577452*^9, 3.945847473866535*^9}, {3.9458476375888367`*^9, 
   3.945847641254919*^9}, {3.945847770316178*^9, 3.9458477741893463`*^9}, {
   3.94584781182493*^9, 3.9458478153183575`*^9}, {3.94584788583465*^9, 
   3.945847888720951*^9}, {3.94584794845273*^9, 3.9458479545306664`*^9}, {
   3.945848036235821*^9, 3.945848039850874*^9}, {3.945848209145437*^9, 
   3.945848213365254*^9}, {3.945848428704586*^9, 3.945848437990104*^9}, {
   3.945848526693582*^9, 3.945848534626331*^9}, {3.945848666528978*^9, 
   3.94584868269029*^9}, {3.945848775077949*^9, 3.945848778998434*^9}, {
   3.945848877398905*^9, 3.945848886629158*^9}, {3.9458491238654*^9, 
   3.945849128054989*^9}, {3.945849197156975*^9, 3.9458492011715355`*^9}, {
   3.9458492397412167`*^9, 3.945849244243763*^9}, 3.945849479846901*^9, {
   3.945851715909244*^9, 3.945851732617178*^9}, 3.945853235726444*^9, {
   3.945853633264748*^9, 3.9458536354922667`*^9}, {3.946058981146543*^9, 
   3.946058983238126*^9}, {3.946113816440451*^9, 3.946113833217655*^9}, 
   3.946113923272053*^9, 3.9462998579964046`*^9},
 CellLabel->"In[8]:=",ExpressionUUID->"90297db1-2eea-6346-9338-a3e8dcfe0024"]
}, Closed]],

Cell[CellGroupData[{

Cell["QAP constructions", "Subsection",
 CellChangeTimes->{{3.946258018000845*^9, 3.9462580514460297`*^9}, {
  3.946439582465828*^9, 
  3.94643958360841*^9}},ExpressionUUID->"79ef6085-3de7-3c49-8561-\
f943fbd2d431"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP1", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258220966779*^9, 3.946258253166219*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"e725b315-4161-274c-8798-a4e0c807d6a8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP2", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"PonceletPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258127112749*^9, 3.946258205014044*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"60fea3de-a36e-734d-b67f-75eab8f36838"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP3", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258267006763*^9, 3.946258272798765*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"422bd8e2-a85e-d748-b542-6c9b62c11efd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP4", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsogonal", "[", 
        RowBox[{"P", ",", 
         RowBox[{"{", 
          RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsogonal", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"{", 
          RowBox[{"P", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258285271057*^9, 3.946258529254532*^9}, {
  3.946258821686931*^9, 3.946258862614427*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"d021f1ab-c58d-b74b-8aa5-a62365464cc5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP5", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsotomico", "[", 
        RowBox[{"P", ",", 
         RowBox[{"{", 
          RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", "P"}], 
      "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsotomico", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"{", 
          RowBox[{"P", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", "Q"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946552139912605*^9, 3.946552177047758*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"023d4850-e194-b941-a762-4c9a532e11d1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP6", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Medio", "[", 
    RowBox[{
     RowBox[{"QAP2", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}], ",", 
     RowBox[{"QAP4", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946554002925066*^9, 3.946554042045203*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"62ef2468-c328-714d-8bf7-299b142a086d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP7", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Q1", ",", "Q2", ",", "Q3", ",", "Q4", ",", "R1", ",", "R2"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Q1", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q2", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q3", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q4", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R1", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q2", ",", "Q3", ",", "Q4"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R2", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q1", ",", "Q3", ",", "Q4"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R1"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R2"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946258285271057*^9, 3.946258529254532*^9}, {
  3.946258821686931*^9, 3.946258862614427*^9}, {3.946290848591799*^9, 
  3.946291021534954*^9}, {3.946291111031261*^9, 3.946291120455242*^9}, {
  3.946696200711548*^9, 3.946696200806263*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"d734f707-6812-364b-b359-ac3a6bb66e72"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MiquelPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"U", ",", "V", ",", "O1", ",", "O2"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"U", "=", 
       RowBox[{"Punto", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "Q"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"V", "=", 
       RowBox[{"Punto", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "S"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"O1", "=", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "S", ",", "U"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"O2", "=", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"R", ",", "S", ",", "V"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimetriaAxial", "[", 
       RowBox[{"S", ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"O1", ",", "O2"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]",
     "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946294457093628*^9, 3.946294688202664*^9}, {
   3.9462961458488*^9, 3.9462961471441994`*^9}, 3.9462963028076897`*^9, {
   3.9462973681984005`*^9, 3.946297370950136*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"34f7e383-98aa-bc47-9867-166186424dd4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MiquelCircle", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"U", ",", "V", ",", "W", ",", "O1", ",", "O2", ",", "O3"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"U", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"V", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O1", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "S", ",", "U"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O2", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"R", ",", "S", ",", "V"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O3", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"Q", ",", "R", ",", "U"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CircunferenciaTresPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"O1", ",", "O2", ",", "O3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946295931650831*^9, 3.9462959921519623`*^9}, {
  3.9462960978401566`*^9, 3.946296126960247*^9}, {3.946296309416164*^9, 
  3.946296387663599*^9}, {3.946296507206955*^9, 3.946296515015978*^9}, {
  3.9462965951590157`*^9, 3.9462966339272327`*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"4370c731-693f-a941-82c8-1f6a14f724b2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP8", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"SimetriaCentral", "[", 
    RowBox[{
     RowBox[{"QAP4", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}], ",", 
     RowBox[{"QAP2", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946554262541748*^9, 3.946554276084837*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"6e2024d9-4541-ea4e-a308-49a8bb9b87a5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP9", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c1", ",", "c2", ",", "c3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"c1", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c2", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "Q", ",", "S", ",", "R"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c3", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "R", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CentroRadical", "[", 
      RowBox[{"c1", ",", "c2", ",", "c3"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9462975678957386`*^9, 3.94629768995805*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"384fc915-4ebd-5342-9174-a166a5e7f52d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP10", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Baricentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946554372389721*^9, 3.94655438207695*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"e878baba-ea71-dd4f-b972-2e4c3753c774"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP11", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Circuncentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946554416053346*^9, 3.946554423653038*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"4200ee2b-abeb-b246-85fa-68f1ce5d836b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP12", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->"In[22]:=",ExpressionUUID->"8131db8a-5012-e741-93f3-ec6da52923f1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP34", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"P1", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P2", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P3", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P4", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"QAP2", "[", 
       RowBox[{"{", 
        RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946362022452154*^9, 3.9463621697479362`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"3e5eb206-464c-7e4f-b628-98c50c5a4629"]
}, Closed]],

Cell[CellGroupData[{

Cell["Auxiliary functions", "Subsection",
 CellChangeTimes->{
  3.818667972143658*^9, {3.8186680382464933`*^9, 3.818668041714528*^9}, {
   3.818668136826049*^9, 3.818668143553762*^9}, {3.818685183717651*^9, 
   3.818685185711126*^9}},ExpressionUUID->"d004e03f-8f12-9a43-865f-\
339812029417"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"EqualPointsQ", "[", 
      RowBox[{"ptP_", ",", "ptQ_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cross", "[", 
           RowBox[{"ptP", ",", "ptQ"}], "]"}], "/.", "sustS"}], "/.", 
         "sustC"}], ",", "cond"}], "]"}], "===", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.947132996916015*^9, 3.9471330125156*^9}, {
  3.947133479684403*^9, 3.947133480044634*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],

Cell[CellGroupData[{

Cell["Quadrilateral routines", "Subsection",
 CellChangeTimes->{{3.945509919017998*^9, 
  3.945509932600797*^9}},ExpressionUUID->"2a49be25-3c4e-430e-86c6-\
869880736f30"],

Cell[CellGroupData[{

Cell["Vertex centroid", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.947132319963703*^9, 
  3.947132328106987*^9}},ExpressionUUID->"a576f9af-1f5b-4213-b4d3-\
e7b66981337e"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3Qd8FGX+P3D+v7v7nb+zAPZTT7EgoJyn56moZ0fQKBq6dIggATVSgmBo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    "], {{0, 389.2075471698113}, {491.0943396226415, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{491.0943396226415, 389.2075471698113},
  PlotRange->{{0, 491.0943396226415}, {0, 389.2075471698113}}]], "Text",
 CellChangeTimes->{
  3.945509787103263*^9},ExpressionUUID->"f7950398-57cb-4ee6-bf14-\
597b39eb91df"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"P", ",", "Q"}], "]"}], ",", 
       RowBox[{"Medio", "[", 
        RowBox[{"R", ",", "S"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"P", ",", "S"}], "]"}], ",", 
       RowBox[{"Medio", "[", 
        RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
  3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
  3.9455136200666037`*^9}, {3.946439211017157*^9, 3.946439211737526*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"cf738f77-0d96-4e62-81a0-f2a504594dc8"]
}, Closed]],

Cell[CellGroupData[{

Cell["Poncelet point", "Subsubsection",
 CellChangeTimes->{{3.945509682961616*^9, 3.945509705247427*^9}, {
   3.945516718286007*^9, 3.945516720220911*^9}, 
   3.947132291355841*^9},ExpressionUUID->"f7957972-a4e9-446f-bafd-\
6774f0dd3699"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "PuntoDePoncelet", " ", "is", " ", "implemented", " ", "in", " ", "the", 
    " ", "baricentricas", " ", "package"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"PonceletPoint", "[", 
     RowBox[{"{", 
      RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
    RowBox[{"PuntoDePoncelet", "[", 
     RowBox[{"P", ",", 
      RowBox[{"{", 
       RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.945506298668439*^9, 3.9455064957646704`*^9}, {
  3.945508100242526*^9, 3.945508119954049*^9}, {3.9455093671686244`*^9, 
  3.945509538952415*^9}, {3.9455167413982186`*^9, 3.945516826125304*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"44de57fd-6e7d-4d98-94a0-c7b93947eadd"]
}, Closed]],

Cell[CellGroupData[{

Cell["Steiner point", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.947132277507908*^9, 
  3.947132283924074*^9}},ExpressionUUID->"ae32c2db-9871-344f-aabd-\
a2543db56100"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "X", ",", "Y", ",", "Z", ",", "T", ",", "U", ",", "V", ",", "W"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"X", ",", "Y", ",", "Z", ",", "U", ",", "T"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Apply", "[", 
          RowBox[{"Medio", ",", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"P", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"R", ",", "Q"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "R"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"S", ",", "Q"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"V", ",", "W"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Circuncentro", "[", "#", "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"X", ",", "Y", ",", "U"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Y", ",", "Z", ",", "T"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimetriaAxial", "[", 
       RowBox[{"Y", ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"V", ",", "W"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945506298668439*^9, 3.9455064957646704`*^9}, {
  3.945508100242526*^9, 3.945508119954049*^9}, {3.9455093671686244`*^9, 
  3.945509538952415*^9}, {3.945518206235336*^9, 3.945518260181164*^9}, {
  3.945518437370175*^9, 3.9455184493471375`*^9}, {3.947132243612131*^9, 
  3.947132244379742*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"db0fcba9-9144-4df7-981b-db22bb466a6e"]
}, Closed]],

Cell[CellGroupData[{

Cell["Diagonal point", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
   3.945521331783347*^9, 3.9455213360947638`*^9}, 
   3.947132343027188*^9},ExpressionUUID->"29f12ada-9fd0-4747-b323-\
2cf96d6fb52e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"P", ",", "R"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
  3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
  3.9455136200666037`*^9}, {3.945521346455207*^9, 3.9455213813107405`*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"158fb412-c771-43ab-b43b-a357380f4a11"]
}, Closed]],

Cell[CellGroupData[{

Cell["Central quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.9464416787367783`*^9, 3.946441687230852*^9}, 
   3.947147898383025*^9},ExpressionUUID->"5a543829-5641-9144-8dd0-\
57eb7cf1938d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentralQuadrilateral", "[", "n_", "]"}], ":=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptB", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}]}], "]"}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellLabel->"In[32]:=",ExpressionUUID->"35cb8ff3-829e-654a-a95d-e2c972de6be9"]
}, Closed]],

Cell[CellGroupData[{

Cell["Area of a quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 
  3.945509840152308*^9}},ExpressionUUID->"e039afe9-d89d-4ec4-94b9-\
ddb3f9f259e0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AreaQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"AreaTriangulo", "[", 
     RowBox[{"{", 
      RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}], "+", 
    RowBox[{"AreaTriangulo", "[", 
     RowBox[{"{", 
      RowBox[{"R", ",", "S", ",", "P"}], "}"}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945518557002711*^9, 3.945518607763227*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"2db3c5dc-e4da-4371-937a-22cb108c81e1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Perspective quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945619500071995*^9, 3.9456195111611595`*^9}, {
   3.94561961722077*^9, 3.945619628845907*^9}, {3.945620201468649*^9, 
   3.945620207996176*^9}, {3.946093948975952*^9, 3.946093951552325*^9}, 
   3.94619393871496*^9, 
   3.947147899655007*^9},ExpressionUUID->"bd16b166-d506-5544-b5d0-\
7aa6edfca35b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PerspectiveQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "P2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"R1", ",", "R2"}], "]"}]}], "}"}], "]"}], "==", "0"}], "&&", 
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "P2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"S1", ",", "S2"}], "]"}]}], "}"}], "]"}], "==", 
    "0"}]}]}]], "Input",
 CellChangeTimes->{{3.945619541933253*^9, 3.945619598797678*^9}, {
  3.945620227236483*^9, 3.945620398996369*^9}, {3.946093956887635*^9, 
  3.9460940140877304`*^9}, {3.9460946192084503`*^9, 3.9460946637685833`*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"6cd12b17-ccf6-1f40-8216-e746f72a898c"]
}, Closed]],

Cell[CellGroupData[{

Cell["Similar and homothetic quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 3.945509840152308*^9}, {
  3.945518917754542*^9, 3.945518929298341*^9}, {3.94551954978488*^9, 
  3.945519554745524*^9}, {3.9471326902197247`*^9, 3.9471326941873684`*^9}, {
  3.947132774954735*^9, 
  3.947132785771118*^9}},ExpressionUUID->"d546f79d-5ed9-4f99-846e-\
3ac1a3756b86"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SimilarQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SonSemejantes", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "Q1", ",", "R1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"P2", ",", "Q2", ",", "R2"}], "}"}]}], "]"}], "&&", 
    RowBox[{"SonSemejantes", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Q1", ",", "R1", ",", "S1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q2", ",", "R2", ",", "S2"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945518557002711*^9, 3.945518607763227*^9}, {
  3.9455189375627*^9, 3.945519039097607*^9}, {3.945519562008997*^9, 
  3.945519564865857*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"5668c7c2-b2f3-48b4-bb4e-3f493e46ab9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SonHomoteticos", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "Q1", ",", "R1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"P2", ",", "Q2", ",", "R2"}], "}"}]}], "]"}], "&&", 
    RowBox[{"SonHomoteticos", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Q1", ",", "R1", ",", "S1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q2", ",", "R2", ",", "S2"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.9455195703380117`*^9, 3.945519605171223*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"d07dfa48-d9b6-433c-9d4d-8f2532f1bec3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Congruent quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945619500071995*^9, 3.9456195111611595`*^9}, {
   3.94561961722077*^9, 3.945619628845907*^9}, {3.945620201468649*^9, 
   3.945620207996176*^9}, 3.946437820730978*^9, 
   3.9471479009831057`*^9},ExpressionUUID->"8f461d45-0647-c84b-9fe0-\
f72d3601c63f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CongruentQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P1", ",", "Q1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P2", ",", "Q2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"Q1", ",", "R1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"Q2", ",", "R2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"R1", ",", "S1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"R2", ",", "S2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"S1", ",", "P1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"S2", ",", "P2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P1", ",", "R1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P2", ",", "R2"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945619541933253*^9, 3.945619598797678*^9}, {
  3.945620227236483*^9, 3.945620398996369*^9}, {3.946287549140295*^9, 
  3.946287549827748*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"5485ed32-34f6-e64e-bd2a-b4e163c2b97f"]
}, Closed]],

Cell[CellGroupData[{

Cell["Orthogonal quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.946437760717503*^9, 3.9464377702703495`*^9}, 
   3.947147903551467*^9},ExpressionUUID->"54169a90-c35c-7a4a-a37f-\
78c9753e8eeb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OrthogonalQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "Q1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"P2", ",", "Q2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "R1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q2", ",", "R2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"R1", ",", "S1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"R2", ",", "S2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"S1", ",", "P1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"S2", ",", "P2"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9455195703380117`*^9, 3.945519605171223*^9}, {
  3.9460039858449364`*^9, 3.946003994260566*^9}, {3.946004044908913*^9, 
  3.946004131276815*^9}, {3.946004174101141*^9, 3.946004205589377*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"c1bc4c8d-1ecd-654a-b9e2-f902b4037dfa"]
}, Closed]],

Cell[CellGroupData[{

Cell["Conconic quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.946188760871956*^9, 3.946188779525741*^9}, {
  3.9464378271237335`*^9, 
  3.946437830963283*^9}},ExpressionUUID->"e126572d-bdab-a047-b925-\
c2661290f09e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "returns", " ", "TRUE", " ", "if", " ", "ABCD", " ", "and", " ", "EFGH", 
    " ", "are", " ", "conconic"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"conconicQuadQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA_", ",", "ptB_", ",", "ptC_", ",", "ptD_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE_", ",", "ptF_", ",", "ptG_", ",", "ptH_"}], "}"}]}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "conic", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"conic", "=", 
        RowBox[{"ConicaCincoPuntos", "[", 
         RowBox[{"{", 
          RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD", ",", "ptE"}], 
          "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sustituirxyz", "[", 
            RowBox[{"conic", ",", "#"}], "]"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{"ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], "==", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.946440275192674*^9, 3.946440364775547*^9}, {
  3.946557553720074*^9, 3.94655756021654*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"3eac6f83-9820-5d4f-9acd-4f2df1b13510"]
}, Closed]],

Cell[CellGroupData[{

Cell["Find QA center", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 3.945509840152308*^9}, {
  3.945518917754542*^9, 3.945518929298341*^9}, {3.94551954978488*^9, 
  3.945519554745524*^9}, {3.946186993811855*^9, 
  3.946187000755444*^9}},ExpressionUUID->"1d12da59-37f1-9842-ad9c-\
eb916041816f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "findQACenter", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"findQACenter", "[", 
    RowBox[{"ptP_", ",", 
     RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"found", "=", "0"}], ",", "sustCS", ",", 
       RowBox[{"nc", "=", 
        RowBox[{"Length", "[", "QAP", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sustCS", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"sustS", ",", "sustC"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Monitor", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "<=", "nc"}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"Simplify", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Cross", "[", 
                   RowBox[{"ptP", ",", 
                    RowBox[{"QAP", "[", "i", "]"}]}], "]"}], "//.", 
                  "sustCS"}], ",", "cond"}], "]"}], ")"}], "==", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
             RowBox[{
              RowBox[{"found", "=", "i"}], ";", 
              RowBox[{"Break", "[", "]"}]}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<Identifying the center... \>\"", ",", 
           RowBox[{"ProgressIndicator", "[", 
            RowBox[{"i", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "nc"}], "}"}]}], "]"}], ",", "\"\< \>\"", ",",
            "i", ",", "\"\</\>\"", ",", "nc"}], "}"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"found", "==", "0"}], ",", "\"\<unknown\>\"", ",", 
        RowBox[{"\"\<QA-P\>\"", "<>", 
         RowBox[{"ToString", "[", "found", "]"}]}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.946187173054329*^9, 3.946187213931603*^9}, {
   3.946187246486248*^9, 3.9461872843092823`*^9}, 3.946187365054121*^9, {
   3.946187480278492*^9, 3.9461874874540024`*^9}, 3.9461880462086487`*^9, {
   3.9461881054797783`*^9, 3.9461881291423397`*^9}, {3.946188268454359*^9, 
   3.9461883008316956`*^9}, {3.94618835627853*^9, 3.946188455318756*^9}, 
   3.946257761266403*^9, {3.946258916015583*^9, 3.94625896478343*^9}, {
   3.946259615877109*^9, 3.946259655534961*^9}, {3.947132891348004*^9, 
   3.947132924188181*^9}, {3.9471329718839912`*^9, 3.9471329845888424`*^9}, {
   3.947133025988367*^9, 3.94713303106756*^9}, {3.9471334511324472`*^9, 
   3.94713348841169*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"806c98e7-c027-de46-8fc2-cc2eda959f64"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Cyclic quadrilateral routines", "Subsection",
 CellChangeTimes->{{3.945509919017998*^9, 3.945509932600797*^9}, {
  3.947162988550743*^9, 
  3.9471629928866825`*^9}},ExpressionUUID->"40e5692f-48f3-024d-af81-\
1a5914b0813b"],

Cell[CellGroupData[{

Cell["Circumcenter of a cyclic quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.945610802689909*^9, 3.945610812713859*^9}, {3.9456119081446075`*^9, 
  3.9456119094484024`*^9}},ExpressionUUID->"9332bfd4-b794-9542-bea9-\
284a11b178c6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Circuncentro", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
   3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
   3.9455136200666037`*^9}, {3.94561082469837*^9, 3.94561088310631*^9}, 
   3.94561179568902*^9, {3.945611920705227*^9, 3.945611942711619*^9}, 
   3.945616284586939*^9, 3.946652944770241*^9},
 CellLabel->"In[42]:=",ExpressionUUID->"5bc10ce3-9329-a946-86e7-d45107084797"]
}, Closed]],

Cell[CellGroupData[{

Cell["Anticenter of a cyclic quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.945610802689909*^9, 
  3.945610812713859*^9}},ExpressionUUID->"4a989280-28db-ca4e-bb0b-\
101f688af051"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvV1sU1f6/7t1zs258MXxZS4icRRZygVShaxIJwhV8UUQyFKCQFYUiCwb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    "], {{0, 470.71698113207543`}, {687.3962264150942, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{687.3962264150942, 470.71698113207543`},
  PlotRange->{{0, 687.3962264150942}, {0, 470.71698113207543`}}]], "Text",
 CellChangeTimes->{3.946004699225712*^9, 3.946093819523939*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"113413b2-0b67-2b41-9e95-6ce395a68d94"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "4", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945615970386856*^9, 3.945615990738682*^9}, {
  3.945616055354908*^9, 3.945616056555292*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"80d07db2-b412-a249-8575-62ea6579cc8c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Det", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Recta", "[", 
       RowBox[{"ptA", ",", "ptE"}], "]"}], ",", 
      RowBox[{"Recta", "[", 
       RowBox[{"ptB", ",", "ptF"}], "]"}], ",", 
      RowBox[{"Recta", "[", 
       RowBox[{"ptC", ",", "ptG"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"cyclic", "==", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.945616063892462*^9, 3.94561615265847*^9}, 
   3.945616195998407*^9, {3.945616235402563*^9, 3.945616239194622*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"77841308-7f6b-cd46-a7ee-3ab0abd88dc2"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.945616132242279*^9, 3.9456161534983864`*^9}, 
   3.945616239883318*^9, 3.946004699315471*^9, 3.94609382722101*^9, 
   3.94628605964624*^9, 3.946286115022316*^9, 3.9463041366547737`*^9, 
   3.9463542991639366`*^9, 3.946641450487358*^9, 3.946651644201889*^9, 
   3.94666495833173*^9, 3.946704343778169*^9, 3.9470095409741*^9, 
   3.9470458183663616`*^9, 3.947163230856423*^9, 3.9471715489457254`*^9, 
   3.947219947922556*^9, 3.947265254548345*^9, 3.947568635645853*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"064119d9-7da6-8740-bc4f-13ac24a9e10f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Det", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Recta", "[", 
       RowBox[{"ptA", ",", "ptE"}], "]"}], ",", 
      RowBox[{"Recta", "[", 
       RowBox[{"ptB", ",", "ptF"}], "]"}], ",", 
      RowBox[{"Recta", "[", 
       RowBox[{"ptD", ",", "ptH"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"cyclic", "==", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.94561616454653*^9, 3.945616176514675*^9}, 
   3.945616209284635*^9, {3.945616251434223*^9, 3.94561625544273*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"50b1474a-8391-ca4a-aad2-5206c808fb4f"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9456161774445515`*^9, 3.945616256355671*^9, 
  3.946004699341404*^9, 3.946093827246943*^9, 3.9462860597190437`*^9, 
  3.946286115044258*^9, 3.946304136680708*^9, 3.946354299188868*^9, 
  3.946641450515772*^9, 3.946651644225818*^9, 3.9466649583586617`*^9, 
  3.9467043438031025`*^9, 3.947009541000035*^9, 3.947045818392288*^9, 
  3.9471632309232426`*^9, 3.947171549013541*^9, 3.947219947933527*^9, 
  3.947265254558319*^9, 3.9475686356558247`*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"9455086c-f72f-5f43-a354-f7e829955352"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Medio", "[", 
    RowBox[{"P", ",", 
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
   3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
   3.9455136200666037`*^9}, {3.94561082469837*^9, 3.94561088310631*^9}, 
   3.94561179568902*^9, 3.946652955754562*^9},
 CellLabel->"In[46]:=",ExpressionUUID->"448ea2bb-3258-a841-a2d3-d7177e41cebf"]
}, Closed]],

Cell[CellGroupData[{

Cell["Centrocenter of a cyclic quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.945610802689909*^9, 3.945610812713859*^9}, {3.945611043737335*^9, 
  3.945611045361271*^9}},ExpressionUUID->"6221cf63-919d-e141-8412-\
466cad561c91"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQ1wVGd673mym9rdSqlqV9lkUl0JG3IVZTV7ufEwSk8FD5nbqhu0zOgO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    "], {{0, 186.79245283018867`}, {724.0754716981131, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{724.0754716981131, 186.79245283018867`},
  PlotRange->{{0, 724.0754716981131}, {0, 186.79245283018867`}}]], "Text",
 CellChangeTimes->{3.94561131365608*^9, 3.946093845394991*^9},
 CellLabel->"In[50]:=",ExpressionUUID->"56df0d81-b84a-0a40-8935-622d3a9520bb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945615970386856*^9, 3.945615990738682*^9}, {
  3.945616055354908*^9, 3.945616056555292*^9}, {3.945616329113766*^9, 
  3.9456163297459545`*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"2a84e9eb-3b52-7d4c-8269-c5737e1783b0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sustituirxyz", "[", 
    RowBox[{
     RowBox[{"CircunferenciaTresPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG"}], "}"}], "]"}], ",", "ptH"}], 
    "]"}], ",", 
   RowBox[{"cyclic", "==", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.945616345620476*^9, 3.9456164106663303`*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"c59ea1e9-aaa1-ba42-8ac2-a180175f33d0"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.945616363395457*^9, 3.945616411439913*^9}, 
   3.946004699418197*^9, 3.9460938517686424`*^9, 3.946286128815033*^9, 
   3.94630413672262*^9, 3.946354299225767*^9, 3.946641450558687*^9, 
   3.94665164426383*^9, 3.946664958394562*^9, 3.946704343842997*^9, 
   3.947009541038946*^9, 3.947045818433208*^9, 3.947163230958145*^9, 
   3.947171549053409*^9, 3.94721994795644*^9, 3.9472652545842533`*^9, 
   3.9475686356847534`*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"defac836-d0fd-5d46-b0dc-913474e2b60d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentrocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"G1", ",", "G2", ",", "G3", ",", "G4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G1", ",", "G2", ",", "G3", ",", "G4"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Baricentro", "[", "#", "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Q", ",", "R", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "R", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q", ",", "R"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"G1", ",", "G2", ",", "G3"}], "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
   3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
   3.9455136200666037`*^9}, {3.94561082469837*^9, 3.94561088310631*^9}, {
   3.945611048795094*^9, 3.945611225281727*^9}, {3.945611707609211*^9, 
   3.945611722193455*^9}, 3.946652966770469*^9},
 CellLabel->"In[49]:=",ExpressionUUID->"58f5683c-eea5-5f4d-908b-138ff9f5786b"]
}, Closed]],

Cell[CellGroupData[{

Cell["Orthocenter of a cyclic quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.945610802689909*^9, 3.945610812713859*^9}, {3.945611043737335*^9, 
  3.945611045361271*^9}, {3.94561156951313*^9, 
  3.945611571897038*^9}},ExpressionUUID->"27f808e6-e579-8044-bb27-\
905ebef0af91"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnX9sU2ea7w0UkqCoupn/LC33tspmylbcqXpTaycVMzfRHaJWaHFLFSEo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    "], {{0, 148.75471698113208`}, {522.3396226415094, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{522.3396226415094, 148.75471698113208`},
  PlotRange->{{0, 522.3396226415094}, {0, 148.75471698113208`}}]], "Text",
 CellChangeTimes->{3.946004699433159*^9, 3.946093874356119*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"b9f0a34c-bb41-5b40-8075-20f44c1ed2ab"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "4", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945615970386856*^9, 3.945615990738682*^9}, {
  3.945616055354908*^9, 3.945616056555292*^9}, {3.945616329113766*^9, 
  3.9456163297459545`*^9}, {3.945616452417559*^9, 3.945616453058086*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"289e036b-59cc-294d-8968-9f3882987b07"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sustituirxyz", "[", 
    RowBox[{
     RowBox[{"CircunferenciaTresPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG"}], "}"}], "]"}], ",", "ptH"}], 
    "]"}], ",", 
   RowBox[{"cyclic", "==", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.945616345620476*^9, 3.9456164106663303`*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"5cb44932-662b-c34f-9d5e-9a4f33e7d9e5"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.945616363395457*^9, 3.945616411439913*^9}, 
   3.9456164568814487`*^9, 3.946004700309868*^9, 3.946093879603981*^9, 
   3.946286139083276*^9, 3.946304137587335*^9, 3.946354300080492*^9, 
   3.946641451454262*^9, 3.946651645133545*^9, 3.946664959321087*^9, 
   3.946704344703785*^9, 3.947009541908619*^9, 3.947045819301859*^9, 
   3.947163231892654*^9, 3.947171549989996*^9, 3.947219948016279*^9, 
   3.947265254642094*^9, 3.9475686357445927`*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"f9e61ab7-be83-e74f-be8c-74d80405ac99"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OrthocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"H1", ",", "H2", ",", "H3", ",", "H4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "H2", ",", "H3", ",", "H4"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Ortocentro", "[", "#", "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Q", ",", "R", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "R", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q", ",", "R"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "H2", ",", "H3"}], "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945611735225509*^9, 3.945611777816695*^9}, 
   3.946652975162092*^9},
 CellLabel->"In[52]:=",ExpressionUUID->"b3d30327-18b8-3e47-8ce7-7916c293687d"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Properties ", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 
  3.946441726397751*^9}},ExpressionUUID->"2609bf4c-7f5c-314e-a744-\
f86d4be283dd"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQlcE9f6/0/4a4VXo/5tv/qVb7VqKdZytVrQKmqv4IJbFbXiQnFX3Bek
Ki4t7rhQt4Ir1iqu1H0DFMWV4oKK4IZYseCCipWooSYy5zeTmUlmkpnJTDIJ
AZ/3K/e+7pVk5izPOedzznnOc+oNndgrxNnJySnMBf+vXkOm+U2ePGT69/8/
/n8CJ4SNHjlhxPDOE34cMXLE5BZD/z/8H6/g/8nD/wfxvxEAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAADAxgkAAAAAAAAAAHshSajbbhYAAAAAAAAAAIAeEOoAAAAAAAAA4ICA
UAcAAAAAAAAABwSEOgAAAAAAAAA4ICDUAQAAAAAAAMABAaEOAABQbsDUKO8u
SolHB66iPHVppwYAAACwDgcU6qocdGwnWjoB9WyNOjXCX0p8Kvkgr8Fo2Gp0
MA9hjC9r8tH0miiywA7pKg+8y0azQ1ALT+TpiTp0QG3qEWUb8VD+FxU/QSk7
0appqDf9FrISPbuhgHko6jjKKUcS4kIMCmpBFKm3N+rZXJfTxehfuZ6uQkcj
UVMFqtIVzchgGb/darNcUt5KT4tuHUIRA5C7E9XciI878tuCCjDzv8a5FMn4
If8nMI3xzjT263g+cjYHQAz8nUapA0ODPG1BsIrLW+dmXxyw9BxIqJMDTSBS
Mnr46v7IdzwKDETBwWh6CFVitSahrTq5rspAgz8v/TIsQ3AOrPKW3qtstHYy
8lYST1Z4Id85aMFuFB+PjhxBSTvR8lDUTElJiJYLUMJzOV9dWuz+wYbK5GoU
o0U0QDGMErNDbZZjylPpYSq0eShlJx7z0P57SFOI5n1LZarpPlQi4iE5+4ie
Fv+MHYvG+bOKpdYI6k/4Z1m24Sf4iDaO/vd5I1A1xk+cO6Pvh1J/CjqANDbL
O2CKQKdRisDQIOPQIFzF5alzsz8OWHoOItRVN9DcnoYyqdof/XwCZalMvqdF
d0/qvumBeq+kVHqplyEfxAqVO4rXlnY6TNGiQ2NsYIEaYgGB6myVyCcapXOt
jWifoO0T6U7GAwUeRE8dasXHUp7sQ26yC3UMbenGu55JYaPa5MJxTdpi7Fh6
tgJDB4dT6a82Bz3Wtaan+wzjuGIkyjb3DCOMVtc5rM4Eo9ENVtFLDTGdhp2B
oUHediGyiu3VuZXDcQE51tBQ+kIdQzl7kJ+SLhAPNOAEeincPDXo/GLk4TCT
HT5OhDmu9TIHYllKD1OhP/R9rBJ1SkLFQt9GmWsMNei5FOWU/Q6ZKVRkVCmJ
Y1kd8phbHN+RvTb5cGSTthi7lZ6NeHMONaTTH5rD8Y8fzkWFEp8JQr1MI6bT
sBswNNhiaBBZxfbp3MrluIAcaWgodaH+YCdDcjdAkXlif3hxoWHJyBGH13do
TSvHtV6ZLVCDjk8zVIf3LsGumARDyWGGNDTciF5anYrSxUZCvfimYeeoxkyU
zTVs2ak/cWyTthjH6Y0t485aOv3MqsHQ1fWomyfyGo8STbcmzQFCvUwjptOw
EzA02GZoEFnF9ujcyum4gBxpaChdoV70J+qgNBRFwDkpx17UaHUXhyhDTkpu
IX8nx7VeeS2QOdtSBKCTIh1SC9G0+nQylKhPmmMdepKKjYQ68eRCdCYObbvM
u9Nkn/7EwU3aYhynN7YMQ/rlqxoQ6mUds52GfYChAdlsaBBTxXbo3MrruIAc
aWgoTaHOUNr4x3kkuiOxNRYmoQYOUIYc6NcEHNV65bRAZqfqhFoekdCpXosy
/FBCN+6Q2E6om8Ue/YnDm7TFOE5vbBkg1AEHBYYGHeV5aCi/4wJypKGhFIX6
w52sKAEdU6Q/4i1a6VP6ZWjKw0Ta695RrVdGC7z3G+P4uRuKkbJPWXIdtbbS
BhyG8twblwWTthjH6Y0tA4Q64JjA0EBSjoeGcjwuIEcaGkpNqGNoRyBjLJDY
ivX8Obv0y5CFFmVuZ5yNdVTrlc0CS9DGdox6DECpkrZFXqOfaht+XmEKemRF
WkqXctsblxGTthjH6Y0tA4Q64IjA0EBTPoeG8j4uIEcaGkpLqGP5aLDSilZM
o/qTuEognvO0lBZlJ6Nfp6GB/lQzUXghzyA0dA1KMQmCQIS4H0+cvTKEuNcb
ni7A+8wBVBR3/CFNhqLQQyjPyCxfoPWhqFcj1gBn+mEOeTn70JRBxBvxTy9d
Ij3jyVyhI4tRkO5+hBoDUehxDic01T20OwqN7GG4EwpPsHtH1PEntOgsKjDX
ZOSyQCwHBTBy98E8JO3gGj5f680on9oo9rXhj+/uoll0+ejvHTDSDDkH0IjO
rDLk6zGsLDGSF7fRH8yHuCOPgWjMDpSpFuqNLaxo3KLEXbsgpjYtyb50k2Yh
pQFa0xYszJ340tOimwkoahTq50utEBL3rw1F4YkobTvq5IqWWR/zGUP5F9DG
eWhsb/oWGCWq1RX5hqPIZJOuRsejXWbqhSpAi7C1ULesviwwEuGO/eYhNCeE
3bEfZoUE1BaihF/RpJ5U1qr4EjUSk2VOa0mvTRkGIBLRnYbhF0Z9mu4VX3ZH
gVHojzzLncNtNzTIOy6gMjc0SKlimwwNVo4LyH5Dg81lkh2GBh2lJdSLjhki
i+If5wkoV65H6yi8hmZ1onrIhrNRdCJxq0LyTvRjB90/eqA+J1jHzzlC3Ova
tSYfLQ8k4rqH7kK79qOze9EAvqPWL1C07naPOaHIW/+QashnuuGuEKPrQkyv
AsQtEFOhDf2IN07bg+b6Uv9udGVJzg4qJm2NSUTWyDsjjm9HM7vTvUEXNOeG
UB8rl1A3qke39UjqrPpEGKsEmGGmOO8dMGr+HNcpcnXI1peY5gnaPIFKTyV/
FLwOxSVRD4kIRM7eaPkCVJunN7awoh+igSbZt0yoW5h96SatR2oDtLgtWF+5
wqWH9wDzOxEJ7h6L4jNQVha6cwf9lYESY1Ffme5xeJWNlvXT9fO6soo6SGTh
VCLasRR1qUfZW1iqcbiMf1I5LifyDDXUS2iq5UmyqVC3uL4sMBLejv0JWj8I
VevH1bHPQJk6j+iCVDSkGlUjx46hw4voc5FK1Pkk7x1SltWmDAMQiehOg3hp
Plo/nnqv/hV4as+eQUu6UDk1E02RH9sNDTKOC6gsDg1SqtgmQ4MV4wKy49Bg
a5lkh6FBT2kJ9Xu/sUpe3v0gg9+UBxrLvl0Xr99Y+rIwv8MmvWUhWkJf54e3
612F6Jc6qOMe1hrLgziD353fMa5aZrYjEftB6r/QKDfaAneh1J+Rxyr0QEsf
piY//ihFb4LP0cRq9L/7oPg3jGdpUMJk+k8eKPQm70vlEuoPthq3IKkYNcPu
Z42/gL1BK/14O2QSdTrqIFDmVpcY3iR/og1DP44b0KKrm5AvY4eI054lVzT9
cLPXLpipTesNRqJJW9wALSkiq3MnVHoatDmQGFAGpHO0dE0emlTf2haEl1U3
cqXUD0VmG78F75E2/EANat6xqMBewTltKNStri8LjMSCjr3oMmpZk10jTHfN
Bii2iCNtVtamPAMQEtVpqG+ikY2pLzRcQxSgIaPM/e6GKO4Nx8/NYuuhQYZx
AZXloUHcdTy2HRokjgvInkODrWWS7YcGJqUl1I3aoIxCXZON+tMV1HArx2qA
9j4aXI3qbE3vVjbc+euOIuegpjuNn8A0DG7HOanWq0VL3anvN5iOfOtSJ9xZ
p2lao8R3XM9XosgC1sOwPGIViPyr82B03cYB/Yzq0fremPMJzIuYuTWDcJlb
V2JYEVrqS3+hLzrHE3/g2lJz9iy1ormKyBKhbr3BSDFpqxqgBUVkde4ESu/d
FfS1YJazVlnVgvCyGkKvvfAFpzUUlxIFnDWzzmwjoW7Bh7dLt94aLWpHkjp2
5yA0qi6KuG/8ZkPIeifkm2T8V1lqU4YBSIewVbD6tEHoEtu8KbPnqSOR2GFo
sHZcQGV7aBDT8G07NEiUOnYdGmwsk2w9NBhR3oQ6hnYPoB/Ld0AVQwdHUN+p
v9V4B5PZ9rmjQjENwHT9E1kl1PGP936698bQqXBqC5W106pBO4KpL7uEoEwj
G2NeLqxEEfnc73y/hLp1JXZ7rWEJy3R01sP0GTbbG4uqaBprhbr1BiPepK1s
gBYUkdW5Eyg9qk75IzkXHUP/q7BQybDKqjGK5+sBMbSHzqDx0pC59FuMUaus
NYK1qc35mTeCFcWLt0u33hotakfSOnYnVGcdMr3lntnGjX05ZKpNGQYgHcJW
wezTOKImqtFmOhnVwiSHTTZNgI2GBhmEelkeGmQQ6lY2RklSx85Dg41lkm2H
BhNKS6iT0w3zvbpEWPsgfVE6Tw+jd7xRDDauQWbbr7OJyxFR0iRdulDXXwJO
ospHOSZ7rJgaXdmDVp/iPk9kvvuSb3BnLjHJ0htzhuGyvkO2vMTeoKXNRZWV
1N5YTEWTWCvUrTcY0SZtbQO0qIiszJ1A6RUepsUn6U55Cl0tZHfLGHp6z8K+
i7WEK3hIh9lbmuqBMub6Yr01WmQk0jp2k8eSCLRxuWpThgFIh5BV0GGNyU/4
A46f43V0MR4tO8ZzZFUEdhgaZOm4yu7QIINQt7IxSpE69h8abCqTbDo0mFJa
Qv3pPkaEVfmCLzFd3yvOQnwnbl+n0Ic7TKyLWX2m/tIENhXqcsQ4sqdQN6pH
7pFFEDLApv4TfIXjOzIqSU4Ens/aWauL4vgPVknrjaUk0nqhLoyMxWttA5S7
LSDrhDp6gkZVM/yVqlwf5DUYjYlFB6zrh5lKRnilgmlapl1lmRPqwkgT6qKN
RBYjF2jjctWmDAOQDgGrYPVp7EBbMmKHocHW44LwK0p9aJBFqAsjo1B3tKHB
Wplky6HBlNIS6qzplZPQDEsSp2cYnvnBLHT1HnEU1/Tz9yFUl6f8ZXZ7kyrU
B6IsKfktfoLSDqLYhUT8In2kJjEjrFyDu9G1FBaMzswCd6rGHc5Ixg5ZaokZ
Js7mniytN5ZS0TIKdQsNRnTxWtsArWgLFudOuPQe7KFCB3B+Pp2GEiwNwMUM
aiFe2pl6O5RdoW6hNVpkJLYW6nLVplx9najFQJk0Dyd2GBrkFeplbmiQV6hb
0hilFG8pDg02kkm2GxpMKbULj9i7b8ITUgG015G3K4qhY2+ymraIj6Ip2sCO
21k2hLousm5EIB26sxXqHoViklDqfaTS2nVFHb1G8/7DKM+RiCcmE29GmPtZ
in7oMtd8TYZKsbTEWKNq2RXqVhqMaJO2tgFaVkTW5c5s6RWkoikd+LPQHu3i
8VkShpkwCdLOpPzLnlC30hodUqjLVZt2EOri+zSrsP3QIE9ZldmhQR6hbk1j
lCJ1SmFosL1MstHQYEqpCXWj+4XZAbTF83QfUlQ2zLXF95Z8OL5Qx1Ro81C6
6DxQ4H5jFyy7CnX8UQsZxinxhlmjSzEaxXNvj1pZKdaUWKkvmyCrhboMBmOR
ULekAUovIutzJ6otYOjpdbRnOZoVYrjbQv+ptgi9kJpThA4NF1tWLEnwNTog
PfiDVGwn1GWwRocU6nLVZrlZUUe2HxpkOLtUlocG64W6tY3RUqFuh6HBfjLJ
BkODKaUo1FEhmlbf2hydCGPNta9GGR4o+So0HTYV6s8SkWdHk/h7kiyQcZbZ
qRoansFx4tjOQr3kLurB2ADi9qvkgRkT2MkHxfFMP62qFOtKzFaOiHYT6rIY
jGiTtrYBSi0iOXInUHqYGt3M56hK/N/vnkNze9I/FIjywY/4smKGpDZdmSxL
Ql0Wa3RIoS5XbdpBqLP6NB5vQ1mw9dAgYzSwsjg0WCvUrW+MUqSOXYcG28sk
mw4NppSmUEeo4DBqwOgxQqXtjRFhOfs6s+baqhTGAy3ye7epUCcarOlPpFgg
M4MfzkUm1+2Ky4LcgzveBvWdqlFU0uL7aO0k9N86xDkLvyXoPLN9sk/Nm944
KT5H2APUl6fMrS0x9gaubEf77SXU5TEY0SZtbQOUWESy5M6Mk0A1FPmE5/Ua
tGeY5Y2IVVaCmWWm0DSibBkS6vJYo0MKdblq0w5C3ahPG3adP61WY9OhwZpx
AZX9ocFKoS5DY5Qidew5NNhBJtl0aDCldIU6Ps/JXEPfy6y7zS2aJ6Alx09V
aHVvk1sGmA1coBh1FJ5FXRoZT9UdXKgzp6XcAa9K0MZ2VlmgJTDi7uKfTiep
CSyWj0a6Iq+FKDYZnT2KokOQs6+him+vMWwdcl+HTWO2UljXVbNL2PoSu8Z4
Amf0SBLHFOryGIx4k7ayAUosIllyZ9abl88jC+ljFEjc1qdglpVA8A1myN9q
KCJPQvotxkZCXR5rdEihLldt2kOo60JE6vVzzWiOiPH6TK1oxTGbkIAthwZr
xgVU9ocGK4W6DI1RktSx49BgB5lk26HBhFIW6ohDq4df4riyyghNPlrRj1vY
vzhL31HrhD5dhfgKCdf5K7twXEolQz/5Dq1owt1jX1rIEbldkgUyg4AZ37ih
Q3MTBSitskDLYN7/q78d+PZa9iiAoTMzkHMfdELNuEqY8+ZlNsx2x5Ej5j6X
SaVYX2JYIfrZm/qr6xTuCMms7DuSUJfHYKSYtFUNUGIRyZI788fu+J2yyN6Y
7xC0WZhlxXcdPDMLjbZyaKoyJNTlsUbHFOoy1aZ9hDrep82jL753aoZiOdcc
EXqwE32usPD4mOFdNhsarBkXUNkfGqwU6jI0RolSx25Dgx1kkq2HBiNKX6jr
eHgaTWhlKJNa41FkMsrhmuer7qEjq1DnOsglCG3hWX43tHQl6nQYvTQpKHUe
WvMDt86XpZ9kHqLRPwQrQvMbca1OSLFALB+Npm+pdmqAItkLMvj8Zb4Hmrne
EPrSextH9pFtBnekQkfn0nMud9RpMzoyz3i5BstDg53R//jQX1OilhtQtqBK
x3mThnzo1BrPYbXoSgyq+zMKq0vnyI3ldSlLiaky0GD6IS3jjb+gLUQb2Efa
K05FD02LvTSEumwGI8WkLW+AUk8MyZE7MfExXEPQCROvSnJTz4mxTigZDGVu
oGN8NUAzso2fg5tWTG96aIvgFi1lSKjLY42OKtRlqU37CHXE7tNcglGCiXkX
/ImCXVDDjbyCSgK2GRqsGRdQ2R8arBTq8nSekqSOvYYGO8gkmw8NbBxEqCOd
E37aVjSeGetGiWp1Qx1DqSuqZ45CvXVbJ4qmKDDOTBMuvIYi+1G7e1X7otGx
KC4J7d+PTu5D0VPRtzVQ1SEsnf8uG40LRFOmoOCvDQmgLs6ORmQ95+wj/u+c
UOStT2E15DOd+MfQVHZeGJNoRRs0ei86k4zWhSDXYHSS0TeRD5w1HXXVR873
Rh0n6146DqUanTmlKUhFIxvT3/dA3XVZO5WIdixFvlVQQCLSqNHqLuxi7IoC
TxqyOXYsGudv+IJnKCubVlJ4FUWNYAzZSuTzK5HCI0dQ4k6i8P3qUf/ecA6K
zxNnxsxtFzrL+AOP7UILAlGNUShDxYrlRWa5e6IMJaZHfR8tpy0Kn0hG7EPx
8dRD/CuhWpPQgRWsDlnhhb70RjFPid9aVtEClUXam8jalCX7Ik3aYAYSG6Bl
RWRN7sSUHtkb4x1Ov3bEf3dbTuzU4/V+Ihnti9Z1Vric2IIKrOuLDTG+3FHL
+SjqIPGKkyeISAIDGlMJ+OEAesp+i1D6TXokMZBVEGjyTENPqPssY5wkItNA
/vu8EYwgGE7IuTP6fij1p6ADSN9bW2ONFhiJPB37O3RwHBo6FM0I5MhgPDsI
gjW1af0AZLbTYKLNR+tDqEaKp6p3NGHeZCNdNR7VU8hg20zkHxqsGxdQ2Rwa
xFSx3YYGqeMCstfQYGuZZJ+hQY/jCHUKDD2/gw7/jpZOQD1bo06NGLbdHQXM
Q1HHRV9qjKH8C2jjPDSyh+E51f2RbzhadM5k5steDmJ96Omb0SoT82PqB0XM
O3ag6UHUqznOywg+UDjYEf7wywdQ1CgU6E8lu4ov6rgY/UF3bvhE/vhqNH08
6uaJPPFPCzTmsthsyoLqb3RqJ1GJvRn3C5CVGD6QaKSKAHTSZKr15k/UcC3i
m4H9k4V+W4CGdKUfqESfDkaTDunsgZ5u4+Xg6Ul9mB2yxSXGAreos2jDbDSQ
8RDcnJZfJMyJmmLr2rs+DWRvbFlFC1QWaW/ia1OW7IsxaePiEt0ALW4LFudO
TOkV7CNGnF1PqLzPHEDbnjty740CowyvsBYtyk5GK2ehEd2QN73ihBsSXlYR
+1EW15AnlH45bmzn+zCXeYXToP8YLT5bbI0WGIk8HTs7prfRh2MxU97alDIA
me00jMHQ0ysobgka29tmts1G9qHBmnEBlcGhQUwV23NokDwuIDsNDTaVSfYb
GnQ4nFAHyjv6qFY1F6Jc9h3BB8dafvM4AAAAUHaBoQEAOAGhDtib1+in2vQk
ehRadozarFyo2w6rs8mKCAMAAABAGQWGBgDgAoQ6YH9OhPFuZok5tgYAAACU
P2BoAABTQKgD9ufJPta5M8OnIYp7U9qJAwAAAEoDGBoAwBQQ6kApUIR+qs/R
G9f/jf/qDQAAAKB8A0MDAJgAQh0oFQoOMy4U1n1cBqLz5gKqAwAAAOUYGBoA
wAgQ6kDpgKEHyWh6TyIOUiUf1HElShUO6AQAAACUe2BoAAA2INQBAAAAAAAA
wAEBoQ4AAAAAAAAADggIdQAAAAAAAABwQECoAwAAAAAAAIADAkIdAAAAAAAA
ABwQEOoAAAAAAAAA4IBIFeoAAAAAAAAAANgHG6l6AADKBNCuAQAAAMAxAaEO
AO850K4BAAAAwDEBoQ4A7znQrgEAAADAMbGNUE/f/UMlEU43HtX9e3kNjhgT
m3Dg3st/LcsAJ+8Sf+voiePt/WXP5i5OTu6e8X/L+HhzFD9LHTOuhWulVqMG
JOcV2/HFllKYub61p45e/tXd8ZoZuCdLyu+xgm1rQv6vUiU/78gTmRrMVskE
bAMIdQAAAABwTGwj1F/kpe2Oj49PSNiWML8eLctr11pwMJ5m//5dybsjf/vl
uwGNK+j+2qDW+I1x+TKp2nepB8cFRkzx8lWSr7avUC/a8FN9BZXpaqMj8jT2
e7WFFOXsGzZ5cucRrSpSyZYm1P86Pf1jupYbNIp/UGKzhAK2AIQ6AAAAADgm
NnZ9+ffRLi9awnGrZUydljDtE0pQe4wYm/GPfAuy+oV9WYV6cdy8D1oGpr3i
/cLDiIGGXYNOwVdey/Zq28KoLGlCnbmBoqy8/NpbmyURsAXlS6hjxecCPvho
Sby2tBMCAAAAAFZT6kIdB3u54ef/0EvQzebFFr6T+BY+bCPUCR3uKyTUsfSD
w6uQqtUlOO6kuqy4glgs1NWP9rXyoKZaI0Nv8pcM4JCUL6GuM2P3pSDUAQAA
gHKAIwh1hHJOhFXRf63+1nsy+U7YQqhri461cxMW6jia7Gu7F83ZnpapLkNu
IBYLdZxXT9PXrZ2z64+812VlWgLoKV9CXdeZgFAHAAAAygWOIdSfXoqsrncW
qTDlxCOJr+HBFkL9ZuK4yk5mhXqZxBqhDpRhypVQf75skpsTCHUAAACgfOCA
Ql0x8lC2xNfwILtQf/vibG8/wp8ehDpQfig/Qh3LSY2oRTRQEOoAAABAucAx
hPrDP2frw4ZU+zg6S6Y4KbIKdez5g+TBAz4nfelBqAPlh/Ih1DH1pVOLG1Fn
JUCoAwAAAOUChxDqmiNr/CpQ3/IIjczn1+naB9nJkb9O8xtIhvt293XvOKjT
ovh4btdoQaGuOp+8Zkho/0a6QOtO+qDuY3eYOpYX5ewPHNW+itKJm0qLLxmC
wD+Nma4LSN6hw2dt6uGqfmTEQw7FgKkzLx+YETXKJ5CZkYWbYy7kvzTKybuz
8QO/8qSf6VOplW6OgGkeH9i7uNMgXyJVCq9uTYYvmXM+z/i3BOp/bqxeN82P
/KaTk1sV34F+87Yf2RHU76OwZc+Z53ZNhLom+/reidODPDs1quCk9K7VJ3TA
VtPCuXl8WhO+kPXvMkJ18ew9W7f+gngIURpvXtzesmNuOyo9xGMnBUbtAef2
UsQyoa634X6UaSkr+fT0Gjw7dE9GDkcsffWL21v/iAoc29td1y7w5tbXZ9Qv
xkZrmbW/Sz0c2qxrowrc7ZN7Wo1pC8+d3jY+YrCXzm7xxPdoGBQ2bLORhRfl
bO/YgrbhtnU/1Jn3q4LUGT8Pquul+Lx6rxljjtx9ijEfezLh1z7jAz/11hUK
mdqI3RFLAz5teeSJBeUMAAAAvM84gFBXPdzbpgH5FWXnTkl/88RSx7R565b3
+0jppHTpvTTqSv5TLYYV38k8OoBY5VZ28tud/dL4J7xCHSv8bd63RMxw576/
HX1JzAsw9f2c8zNmdXIlxtam40NZUSL/fXHrQHx8fNrBwK5UXrx9NqToY8Lv
vv3CMLS/iI8O7v3zwBq0qjcV6urCy1MnEhHLG3vM27f/zrMiTPf2i0uX96vs
5FS7+uhtBwoZU5WSrNSNocum6mPC46rj5auMid/Xnxp+8mYOLirUqYcmk45D
3t677rFL7+ntWK/PFR39fv/zcpGGKsaiS2m/t9M58BiljSXU/1YdXNPpq06b
Tqc8UWPY89x97ZvpashlxJ7LLBn214VVQXwh699lL5vIKo0OPcc1rtZw7LCd
JxNu5P711+WbKdPIMidqcMfNAhDrpYH0dq1RZcyc0sGV0LddZoUeupR6Pzcr
K+vh5TF9iZp2qxZ27A6zKjXXUhY1bob/yeOHwP0ZWSoNwl4+vbaCNPgaofvP
6yMjWWbtWN7tI+xbG2pPDD2TSjfQlNRCozaoyk8eOIi4wQFvg4cS/lb9i94V
P0k6vohYkFf4zVqQrQ+p+vrh2cjVC7rRVwzg5n2v4ESPOgGrt9y5cWrep7pk
tu6Y8pxMffHNsIH/+0GN0G279De4aR/lnp82leht7HztGgAAAFAeKD2hjivG
nPvXN++a9YVut9qtav9FC64947mfFNPkr/xJJ60V7ZftKmKuA799cbIboSGV
PYLTi9i/4hPqmsLD31bjENKY9v6MweQfOBf2DQHSzbm+GL5pJIb1Xu4eHquu
GutSdcKG3sTyvsJv8RbjGJX6vPh+v2vjsGbrE1SGL5RcH9aafFvDhXFvGKt7
ueH9lU4VZ515bpy+wttrv1AKCPUfFi/p6ceKaf/u6JpWzmQCup/9xyTDgpsX
htJQugRvYqacSGThup+9nXkmGoA9kNiuCTk6WOcDxm6Mb5/ua07pa+X4yAL6
3zVXj5MXJSgD+qQVMk2ervraNX+5/IL1CkusnWXAQq4vqoeJ3XRtsHbNyLTH
rARln5lRQ5evVfu5n+zuGbM67IsV+/H0aOOXulNvo/bUsNQdgZWcakfEGu8O
YZqbYwMU9UCoAwAAAFKxo1DnRdF03JgznG4bNIbI5FzBG0uSN7Yjdr2dRx5i
rePxqkfsbfqAluS7G8yOLWI+71biWFJrcLnKWy3UDaLUbcqy56ZKgoz9SLy9
6sxTD7jzUruK26Axt9iXKBleFzjmll7qUsKpwqhDt03KtuTWGH8FQ00RMCur
bp11N9SsX+gT4Oa2/pZJ0kUKdc5ye/v8cBs38u9l4yLX8oa0dq1J2vDdB6RQ
9t6fz7CsEvXlgR1Ifw+D0DXE2Ff023HZ2A6L7qzVid1qEyOfMG3KAmtHIoU6
lr9gNHnSRDk0PNf4bi6iXXBkTf/kaspa37Y+TKr7R9dWfqHzWwsalq7bzSuI
HIln321S5GMTGy5J3tC6stf+fO40AQAAAAAPdhTqRhKu+NXfCeRes06rDwtO
+ItPq9OjJ07AsOtvTP5OB42pZuR0za8escd3E2dOHfDL8htG72TEnzE9UGmt
UH/9IO4rasnRf2MKV4R1Q06NVYTh9k8OwcOdMP3GQe3qo6Ijj15JfaQybFho
n+bffF7Eeg6jsjg0jCEBLJ98479aINQRehkzlVLqnLMAwLZIadclb871aEjV
5pDwB0aK9NWTtFVz5sQfeEwbCD2J5jskrk0L1Cn1xj6Hmf7bFlg7EifU6akB
Tus1iaZXq9Hr5M4TEnM5n8zsZLCiZzfSrz0vphL4fNlEXXtTtJmkc+569FSr
T3px0d938srSrQoAAACAQ1B6Qp3k6e01nrQXim/bpEdcIxnzIZxnM/VfMJLx
FkR9salQ1y/X84dVMfyQV7pw6GS+hBVETfqcvvKVlD1e3ZoMnT0mNjml0FQ0
CescWwp17MyWbhWpFMoWnBMQi5R2/fxq1P+ZE8MMDFXP0wapLxjJeIusXZRQ
NzyZpw3SX2DJeMaTeabYBFhmwtiqzOZGnZVesi026zmPUx8AAAAACCFljLbN
YVLDairfIMiMsu5R3b+nJxs63oiTZKGOvSy4Hn/o97ClE3x7tv6ibS1ldf/v
OuljR8gu1N/tX9FEwftw4x8qKy+/xljUtky6aFQZEwaztTpdG98HJBqd2y09
oc6UTxBYz+5IadfXDw13FV9T9IK5ExlWxdOEXmTUI7sJdYZjORFqqV07o/TQ
wZr4hbpg5FJMdTD2h8oczc2pwacRxzM5guEAAAAAgBBSxmjbCHXm0MmxmY5Y
i3g80Q55EHJ9yTky5scOZIyXob3XJx649Vi3T23LFXVmTs0LdSOJYpl0Qbp4
cSkn1gWH9qxhKGZKOhkdvwWh/p4ipV1Lq6l3V4K/Fm7+5t4is1AXM1nmQMoV
A9rcmwkzFo/2pAS/AdMzswAAAABgBiljtB2EOqeQYwZp4VTyfPCoR30YCqfa
NaYfPM8KQiJdqL9LPRA0c1l2Mc83mTMLs9vuzB82YB89s3BF/d9/GYt42qdP
7qZcODo/OqQm6YLD64hrZ6Fu8GQG15dSQEq7ZsyaOcKbmH6dctt2cqrrsfW+
6AVlOYX6u+xlQUEHUqlWznA/67szXWyCRAp1TPMvc9G8WPUoPet87L5fWlLR
Jo0P0QAAAACAGRxMqBs5ZlNgeRFDqOHep2NKIc+7Xj1JvZmnZQ69nOpRq0rp
QoVtbzg39qXRuCldqGvjF1fyMdaf3EKdcZDt65UHuEZsxgqkUUQLC6QLEfXF
OWDLeVNvIiw/c+WX1YwFeekJdYacq/v7HVhQtzNS2jWj+RibqB5MW5RLHZzE
Lu0eQLnKcIUJpb6veXwxjXVoQk6hrk0LrFRpMf1/1Q93NqVsTWCiobmXepXp
VS5OqBdEhjj/EHrX1Btd8ypjVN9q/PYPAAAAADyUvlDH0nb0/oD+Djvoh+rA
hv7bEt9g+vjGTk7KD+emcip1QsxXCGaPkpzqUVCKo5wTYVV4/2rQk4wBtzhu
3gftgq/wRZBjh2fUh4bjFjmv7v1GiiCl64QEnlCT4qULWfi9hl1/jUwhfxKw
JdXwltIS6v8+2edDlWuDWTGw5Gh3pLXrN7tX+JInf91qRmeqTb+ApW7v/jE9
46avOXAyDXuu//6l3UFV2RM0C/ePDFtvBgPGis8FfNBghX5ezIjbz3kjACLF
fIXuzBmuOKFOJIynTKgc/RCaA4dKAQAAAAmUvlBHz7JWfUbvRjOjsRHRzht+
OJ8c3A2ntJSBA9L/Mb5QBP9rv49qzD7LE3uc+WqGLPRZHMe6OwnTZP8Y+PUn
rflG5JJTW7oZRZDGNNeH/9f1Z3YwdoELj/SXrVSrOuVYNjsbegmh8JsbnW8k
4y0W6k7OfTYcVRmp35I3aX19jIOl20GoK13HH7rOOlKHafKjppLCSdm588nH
EMDO/khs14wTyh4TI+4bGSpx0fCHrVcaLgzC8jPXNNFFYa37adRl40u+dH91
bbGIfcOXhScySu6G9qCcTPSB2Z/fWPWZ68zTj7nSr+gWvd+4aRB/DXbtFHD2
KVccdbNCHX918PAMk0Czb3Yube6sCNh4Es6TAgAAAFKwjVB/kZe2Oz6efam3
U+1aCw5Sd3pfyGMeYsRUR7ePrklrdV/fHVl52nfqvM0xgdXr/3Zbbfja8d1T
6uluGAnwXXUwPuNeVlbW33eTz+wcHuZbheVtrrtS/OzZxUs6VmS+evftF4QO
VB/fNvRj0ke9+ujf4+48L8JKip9dSN83tGfT5Sn3Yn6qT96H4ue9YMPPkWtj
7xgikxf9GURd6eIXseDaX3l3NuKJ9Fib+VKfyMLUI/HxaQcDu1LZ6RV48Hx8
fHpWsX6AVj08HRJCXF9eu/qoNcsvZGfeuZN7/3z6oUkzO7kSN7QOWbOFqdKN
8+JUccKWbQkJZBmavM7bZ0NKfPyRxL/fMNSF0qX3/Ihzdx8Q3giYVpV1M2XK
lNYfMC4J/ffFrQNcN7Drki2YAJ6iJhNAY1BWdas3b1Jj4KplF3ILtBimzr51
fMJE3eXsiqajh502npwA9kGiUEc6NRtOVpyTR1BA3JmTdx/cuZNJXjTs2uLn
qPvsyw6wh7d2dOlGHK5sUGv82mVnstL/wrl848SC6PF1XHx+isymI/pbbu0k
uRcX1qGPn+xLyLl/93RI0IdBY24a7eNoVDfmziKam7KS/9Qxe1NTqPTH7Y3y
9Xfx77jnDi3TTZpG16XLzpwxtnASvZ3jZbItNZWMr64tyL++advE/1N8PoJ1
1S8AAAAAiMA2Qp1xapIT01UprDD/7LJ1C7oM6UqGR3Or0n5Mn7jL2cYLUOp/
sjb8tqDLiG61vHW3klfyCfSZHL3oHPtiU5bfuwHD6hz+unOLf53mF9RV9xwi
3HHogK1pmYSUxQfxlStndQpqQQZsCx6WxvS10bzKXrt+sk9vIiCkslKrkD67
Mh4wHOMZ8eiYGAerwdQZf24fHzHYiw4s6VHdf6BveIxxRvjzQpYhz+vIZe23
T/e1rjFqc/zjgpzEGYuGN9ZFnnSr4hvoNXRheCLTn58ZANMk2YIJ4Pkre12d
tQT6BC/5aKoA6cQcTM+Cu2BKDyfJQp0AU2emHwxfOJS2YXdf994TgtedTDVe
o6a+ri1MOb5myOQgTyoCqruvx8BZY3ZcyGRWveXWrn/P45zDk2YOqK/rRjxq
DFqy4NozbncTIjzLzKhRPv18q+i0vUf1zqO6/7L3jzym5zpf0+DaOSqIHFRj
fGhqfuGdjb/PbjdI91iFV5cvu48NXneC6+YCAAAAADCDpDHasgEdeN8RH9YS
KA2gXQMAAACAYwJCHbA5INQdG2jXAAAAAOCYgFAHbA4IdccG2jUAAAAAOCYg
1AGbA0LdsYF2DQAAAACOCQh1wHaICNMBlD7QrgEAAADAMQGhDtgOUWE6gNIG
2jUAAAAAOCYg1AHgPQfaNQAAAAA4JiDUAeA9B9o1AAAAADgmINQB4D0H2jUA
AAAAOCYg1AHgPQfaNQAAAAA4JiDUAeA9B9o1AAAAADgmUoU6AAAAAAAAAAD2
wUaqHgCAMgG0awAAAABwTECoA8B7DrRrAAAAAHBMQKgDwHsOtGsAAAAAcExA
qAPAew60awAAAABwTECoA8B7DrRrAAAAAHBMQKgDwHsOtGsAAAAAcExAqAPA
ew60awAAAABwTECoA8B7DrRrAAAAAHBMQKhbhFb97HYWRU5Okaa00wO832BF
z3Noe8x69FSLSfo1tGsAAAAAcExAqFtEzomwKvSFUW5u629pJf4eK9i1LGR/
Kgh8QBZexkx1099gFjjmVrGkX0O7BgAAAADHBIS6ReQkh35kgT6nwG4nh33k
5DY95mWJmW++jl/R1rOXf3V3SoMpK/n08GTQpk19d/c2DYPChq5JTikUr/u1
xU9STu2cEjXKpwX1pBZeQ5fMOZ/3klqLxTT5K7+blPzINO3PY+e1EUpSnzZV
XZoHNAyaMWbHhUy1uQyKB7t4YNhHSkl37rqPjch9a/KgkjdpfVtKehD3c4wg
ivT0tgnzQ/RF2tZn1NLwpOynjCLt1Xn/HdPVbl0tczE8NOMV9WNdsQt/h+Bl
zJQKvUCoAwAAAED5AIS6RVgj1EvUlwd2UEpa+fz3yT6favgvGi6Me2Oi87SP
ck+HDP5c4eQxYmzGP+acHrTqvPj4OV95unT1jdoTdz2fdpPAtEWX0jZ1bzo1
MVODYao/VrSvXH/rPX6dXXRnrU6qcyQJ06oyrx8ZNaFVRUWbKeHmkyQJTHN9
eAfixS39jhVwPblY9feJs3E9+uIFUm1i5BP+KtJe3DPsQ/xBioCNJzWmTypW
PTqXtlXEc5DmVfaatZPrf2G2SDso6/5+RyBBRcfaEeviyoA+aYU8hUYXu7L/
8Osqju+UglDXqu9HTak3n8MymajOn1gXHNK5IT616Nry01rdQgdsTZNzHic+
JdrcW4cmhff5iprodBtrg5SQYJrHB/b+EhDUgp4Lj1u/8f5rocRhz3MPdav3
8/lCG6SG5lXBxSXRk1vS08meHVeeSufKPqbOSIsbiFdZgJ9b9ea9fCZHLzqn
n8jLh0jDwDIOBNbvuO18yt0HWbzweSGKMwxHzALRXe+a266795cdatSo1S2k
+y97/8gTNCFL0Ly6s/H32e26eXp6e3/5ba0mnqOXMhZtTGC0IN//enj0njXp
8N2nXF/Gcmf19Zg4fOeJhBu0P5726ZO7J1MPTP2p6cDQm2+sTbi0XkX9z43V
63WW/803Ddy9grrHHE9VveP5MqYtPJkY08PQeFkLWbajuOBw2/+ZncrTAxiy
oCPAb96ueE57wFK3dW3kv/iPjZfvZlMWhY9o6TdOr9o8q2Wz2JtqWRJrwVtE
G48OfGxduz60lfegsHHjug3yDhSsMuvQ3E7fMYYxLoSNTb4vWN1me5XXD+K+
9ZgcHXn0Suoj1b/Ev+CSIOevjPij6wOb/ncTl+rgBYS6RVgh1DVJG777QLdQ
2zX4yivz3yd4ei2qFv4D55GHONZjCdSP9rXywL/hERqZz7+urr13dVObNopG
HvMOn+Refi9+eqJ3o2m/xgRXNpe8v05P/1gwSQgr2rbUt6K46YN46DmLGfFc
lBvn5ezJNa/R83bfSh9n/EEfLb/6mvdL6oc7mzp/zL/3obl1cf23gkX6tvBM
f3FFStWyU8tVB97yJTsvNaI6Mbnosfk8Z4rsKtSLVff2H1nl16WeQnB7CNPk
rwprNS/q2pMiKlt49xs569uKCr+50fnSkmpdShCmOvp7214Djt7Ko934MfW1
8+va1GoyLyb/XzlSon8TLrl7tqsaHGx4F6Z5sm15sx+Xcdqt9tH9C8vXja+D
T8MqTDlhupMlT6LUaQk/uVftuyI6q5DO7auCP0c1G3aE3YrxKosObxoWTikT
XLQkH5nbwMOpwacRxzOljC/CyZFgGFRrFaZZyyOP2IkTaxgOmQXVw4S+TcfF
0UpM/SJr6eKeSif37wMS/5al2dBv6d9q1oHEAjXdJB7n7Onsp/i/GjOOmdY1
pjr0++D/cQ1et+sJaUH4VGJzTL+POL9ccmuMP2cuPYYMOGNly5fYq2D5mRua
N3AdPPzPx+TfiIa/orFrizlcXZBGlTGjh+9iRjPBs7l107B6deS0fw6wJ1Gh
9RXcPQCehd++85131LB1jhU+PDMppJY/hz2UJG9sV4Gr6L/2XHImS64sSHyL
JOMhLDOxW82aMyKz6RrGO9WD39Ws+bNMo4YebfH95bNb1fBcnGgoW82tC1G+
7Q7nc3UZInsVelXNGKVLUPQWiVlwAqFuCRYLdfXDvX4evTr4EvXl7Zv0TNSP
Sk5t6YZre3ehJe4nkaMI/cr7HVyibB9dU6Ho3ClJsJMn3XKceFbv9VCDjmCS
6L0DRftV+2Vby6LULK9S1b/71hg3t/Up/N/BcsP7E/sarTumPLfsOZjqYOwP
lZ2UMhUplrojsBLeil1nnn7MmxqyY+SfXNhFqGO5keMIn6uevhOWblrVxgf/
PX9/hc/XZjdbud94GYSYAeEGq2i/bFeR5SskklKCsJxzYa36cuxWvMiJa+ra
aW2CWjYrvR3r5eIyhDVFxXLOL/b0UtRjN5nXD/Z0aeeF52BswLyY9ZNqONlO
qKuTNgdVcQnelMCoC6xwy/LuVRWKoeFM5y71wZVfjI/MY1sRdj1hHF5jtWvM
PJEtRzlJMwyqfxNA6TohQT/dkGYYjpiFkuKMkV8M2X+dLWBIIYf3OZ1PPpYj
M5qiPwc3W3TJeG8Su7R7gCte1zUj0x4z/6Q5tSO4slODWTHPmVnGNDfHBiia
NNp6x2gFFe8821WqVJeZRXd/79nx+59YOymW2KsQDdzDdBNWkxTbtZLLwJ3n
2UssWOFv079aytEvaU5t7/fxp6uuvbQy9XzQIwVXD0As+Hw1N/WxifjVZIcP
cO097LqK9c8lybF+rvU+VTCK3qPGoEURFx/LqXElvUWa8bx9cba3r3M3481l
XREp/BZvKZRrXb2k+GZYsMsXDddeYxgHXtoD+zSqoOi34zLj9RJ7FVyo169R
oyKzgVdqFdIn7nK29IkSCHWLsFSoF0ZPqLc87d58XY/d0Ht/vqgKo3p4wfVY
6jih8sO5HLtmYiUlgVaV0qWB4FI5Mqhcc5sC1PYBn5uKdKg5i/AyuO6Lt8bU
Gs/hY09Dr8wr2RLFlJcxg7/ZZ1oUWMGan7+tKK5IS96c69HQXJGiog0/4UOw
sFVQlsA/ubC76wu1aMbbX70tTPJv4ORWdVhcAntUpU1IdCuwNiXEiOD78XLu
3YrXW+Z++LXwlE00uPgJaq/4tM66G6yh5+2h1W3xTrsuv/sTtQJjG6Gee3Fh
HYUiaMwtZrvB3l4f7o/XgjI49K5eO71+ENe07vobptvWWF7EEML8ZGnOkgwD
e5s++LNZp3N5Cg5XVjMaLeAbu80ZhsXYMgtY6tYv/NmVRUJpURPBYxGkMlS2
9o7NYNcobgNfETlgbVwW3l77hdKprrFhE8/JODjiQ9P9XF0nfPxhUc69qwfj
4w8cuHo/Tx4fM2klT0hBJaeLIzkKeDfd9zcjWYW313z58TLO8YXoyd1cf44t
soWn3NsXZwYP869ZjbMH0CStq+PFM9rmpUbUMF7eKUleX2tqzPOXT+6mpMTH
x6dkXC0sln8nQMJbJBoPqRw4NpdJYW/Su1oKue9vYhvPslZ9phRcDxTRqxTd
Xu3lm/RQ9Sg94+Qf8fGnU+49L7K0DkCoW4RlQv3R1YVebZOe0KJaZLgYSuYJ
r8fSHRTXEjc5k3WqK3IpAH9UP8V/BOWToM88C9JVQ3CVWBKUUjW/GVFya6z7
LAFfXzF+JgR4aXw52ljwUxMfp68bbrwhanXlSeRI5zqCuw/4OD6gJZEggZML
1BxKyO3H4YQ6PeI7+XY/+49RUqW0AutTQhitsw9PdRNLQ5XkScmb3St8K3Lp
KM2rO5sjI4/x+1jaTqgTe1vtFQrXKcm5Rn/BHt89vCTyaLbBTbTk1KbPRnMb
GDmk4s3Z9DmSkWQY/xbs7t7j3D+mT9Gl6mbK2JZcGyUUNhPqNsxCyd3Qz/of
4J7XU32gHNMlahfPtCenz8swuyNqF9UkswRkURiPPuZWSyxGUsmTXT3PEpZu
3GQtnGIZh4ZV5lsI0tmS5LBaYsAKN01vt+XSgbZunD0AMYJ05hHqun7DfyNr
25eU0PL7erER/xZpxkOOhtxVhl5vmfcfhdmBWxyPrkbVVXI2JdX5o5GrN97h
Vdaihbo4rwlzgFC3CAuEOj4THP9F7/jL+MSNcmDgsUNjzDqoI3q6yumjXpC5
yoOYG3YTvbOPi72KQYwVNlMoT2kzS8QEtJuWUTdiIbRS5VgGf5G9hhnuEm/p
w5tvyeF9J7Uyb74KSm5N8FrNrmgsJzWiluQirdBJcPdBde+3L5Vm5j4i3H4c
TqgjrGDnmlHNWy44YeSFSPuv2m1FnRDqlRU8B3VlW1En1/osm5naTKhTW+pm
vLwoSB3I7QgtdnorKlESDOPplZ+78Ox8qR7ubf/FSqElCJsJddtlgVwJUVbq
EslxdELU4RqRFD9NDR3rPWBAspGfE91vM9YE6ExxylRK2Bu5CthMqEspeWq0
5VkQIIU9c0DRzUZ5XPJst6Kee2Ga/9ibr8hi5BHqNY09kSj4V9QdRqhLNB6y
n+GpMqpC5ZguFUZPq69wajDbggoFoV4WkC7UsfT9ft6UIxm9jiFqRKa+LLBj
jmnyIicRXhPe3rvusW23pDgjpLtS4vLLy5jQ6suEBmJqpBBIkh66w5dnlOTX
CW/3LWy+jTlGIM3jPAHnZ2pVylQlvs6NDZ7BGE+xgoRtd5gCm/Cd85NepGFV
5gk6qJNrlYJzHzGTC8cT6jzodwdGR+TJc52AGNeXAKXuINuJXPZxfkJdf9ja
Km95+iVkPQqf3eDDZkKdtHazXl466L05Y9HFTKFtDmaSSDIMTHt/Tq9mW88L
ftF2Qp0H67OgXzHmMiT6BJ/tDh0bYgUM3nOdsgGuNXZGLqgNQfY6g+2EOg9c
JS+8c8ex0kuueildgn6NNYrRhE94Q2vwqGVr0J0UWH71JSrhFeqUE+nXnktS
jGM0FUb/+GFn4/UHxxLqEo2H6kV51nCE/yoByjGAq6MzT3kQ6m8St4V2G9G5
obf3l/7V6/omFWgLTyb92tO389jJoR2DGnbljSlEoYtBxIrJc4wRJFz98Pj4
mbpo1X18q1QkTLq4IHXG6I4dw3p/5j5uR6JhZ/lVwYX58/t07zEvZnHUrOiI
7wNm7UjK2BzzDWkPJW+uzZ053rebp2eHDp95fxge8/Jf/L1rx7b1GzsFf37D
zmP4Yz1JFeq4EuhS9+ezD6g80/cliVlnpiQl554RIkNJrCH8zzv57bhpciYo
/eBw4kU8EQi5wVQpa/ZkC6xQiXVQJ6CltSyjJK9SLXlzIeizpVdEry/pV+aD
jTcOsIy97XncmEnooD0SizRx8eJrQrKeclAXc15YsIMqM0Kd3JSpXWO2vlFY
i/mU0M3ByalBrUlb4qkTbUR8+2l1guWJTURuy1KtVf3i9rY9y4cNCPxxTGzC
QfNR9Wwk1Nm+c9oH2clLo2f1DwyNitifnmXav2muJs/5smqdAcEn8my6os6D
FMNQJ8U2HR1x34y1212oW58F3CZjIrt+XK3fig22XVHngTRjZdeAs3qXKGGt
RRcyezJod6HOVfLCQp2a9bA6Xix/wejPdQck3QP8Nlygj/6pHiZ2rxOwMUH2
8IDqg7+0itZtzmp5hbo+sJuTspJ/eFgqfVpTc/V4WINGa0wGl7Ik1E2Mh6oU
PgdXUj5Z7zNJ+eXq5ASmLTx3aueUiD59ghduWZ1mPg5neRDqWFHhvZT0lEkT
Ce3RuMnsJT2m7T3JiHtzcUXjjyv14I4xheVnrmni2mL2Mv1kVnvvSkwTRhgl
jSrnaHLypn0/11USJp30d+qYnjty1CVU0AxKxeHPif626eqrLAPGrXraJ4r/
pcoWUz+4f/XAuQ0tCc3mNjRw4fDgXTeYsdRWB1Xh3nyUKtTf7I6qO47hlEK5
jogY7+hBltMtWZt768ioMU0q1xgZwwgkpYdeQrRwfY8P2kFdzIYRvVAsz8jO
rVSLVdkrZjdyk+K3QOsNYz8TosTqBfG4hhLQ1SFzkeod1AXmPvSrhddFy4ZQ
Jw8EKYwikFiJmJRgqkObh35M3Xbl8UPg/svXj43y81tuvHRmZRqI8ejR9Zj+
A/ZexzsmhL18em3F0u51Gi4+KRjbzUZC3eB+lv7PobU9qIh2WPGdzKMDvq/Z
n0uQ8yCnjzr3C6QYRuHtmGZNd94zm3j7CnWbZIGFjD7qfKkilpS/ZsfBEPZe
0HeMrB6MPEz6TBeQvGXLkKEje47u8o3fnK1xMjU3NjwlL+z6Qs2sjWY9GlVG
2MjGZOBBpUvvpVFXLp1c3NEvymQ1WwYKMpe2o48nCAh1KsJkM6rzauwx79Dl
K6uj/AYM5wz3TR3zfHbr0KTJLbt2DJ08I6Sl95CFM1Jy5QwFL/ot0oyHqhRh
oS7Sc1go8bRhZL28NqPH9H26CKXa4idJxxY1qfn9co45smmORBwm/efG6nUT
vm0ZMnVyaMcA7xHBsWctsCJbur5Q5ekyYs9lo+FJk7pnWBX2hJ2ECKP0uakf
qe58lpFLMFlQFYaGf/fdvkxMF/1svns9RaumO7PV5InIChNMxS2WFzHog2ms
sqVm3KZ+I5jmfsSozxVcsYAkCfXC26sbsaMoiN9Bpl2XPQJ9p4UH0gQH9w4f
1rhtLWX1zqP77LvLs/pN/1YZxBU9wGLE+MzT0KGDRX3ZDPrm7FHdvyd5KYG3
95c9m7s48U1k+KBdj1ip0hbkX12xrPf/CCpweoYlzotANPqdbkPWjDDkVHjK
4/hCnVCt82Y0rOYx68BJWdemxKZEF/reV381rceosJtcV0dZlATaRLt3WzB3
cDI7gF5h9JRPPhCMbWgjoU4bbYefxg2dF/uE6WNB+PzUV4iN9UdtpSl7BKcX
yZlA6unSDAPLXzDso+liIp/YT6jbLAsMqL5C1pi3jCTh07c/OrdwDQzYbbI/
y9otMoJevWGLK7zkP/mkZ5vQXQnP9VZHBMf2de4oIliWpHQLlDxz4dQEOmam
SaPDNE92/T66Jt1PKF0Gbj35xgZx+G9O+ma2PuiioFAneFWQGjqxlT7i39eN
Nt14wWkFJcnrPqnvOXxexLVntNwktg5ntXDlCVpuEeLfIsl4aEkmKNSt7iep
JLnV/HnFhMHJrG6ZCgI5f0MBr6gQI9TvrPH8pPvYHlszHtDXdpBrxc6+86SG
gre9UOcsbXqxlxUbgQ6jxOEyRM7xWWsIZEEp6nXpbaj64hdP1fqZ6cfOozhc
BLHUrV9O4RDq3AVOuauZrCBJEOp4bxxcdzm7UxV5a49hCYv7xDreqR4ZOrR2
5VqTth0wvW1H3tVsPaIDJCJd7IIeRE8nxpvdLJzb7pi26MLpBZ85B2wRDqvO
guqc3ar49tIr4T6+VZRm1rQZV5bIW6RiHNQx9oYRH44r1ImA4WRRf9/qo2pD
1m24Y7oHZBWihfrt9C1BfgMmzOxJD8LuvTrtuCHH6qR+h7e2S6DpxXNkZ2IU
C46JjYQ67WhX9+v6pjHNSFcu4YvSKIgAj0rT2NrWYplhPLq69LOPIi++EPEC
2wt1m2dBD3WLnNDlxRaBXdw/kriTsXXrL9pUbeIdfeI8x/VtZMw6rs1E7PaJ
cLe6JkIdy53XblyCiSx8eGnh/zkpAwekW+9sJqbkqRikXLribeGx71rowoBz
CfV926f49/uxXV/SDYY42xsx54asd5NqTm1hnVoVIdQvzpnuN2huWH0PqvNq
8Om0PRyzQuzCrnY/majBkjdpfX2c6n4adVmezRgJb5FiPPYR6nRE6w/+d9BY
40ty6d2ZkIOZPAUlold5/WA7l9/Im51LmzsrukWb3AIgRCkJdb2vL+tcvE6J
cSpAcqmKpVKoguLWulR4H5fgtXF5RusOL//adjyd2XUICXV6QmH8FtFCHZ+a
jXM32aM047JlwHxsbSJoM3GpkOnsT87VbAZmfOaZ6GOVy7Gkz6tUtUVJ/tV/
Ee+gzr1Liz/nTcbIjkrBI59U05ZbSlFTe6sd1JEjC3Um6sJrP/34dRWGo7gM
iEgJps1fO7dRf+pWRNbSuix3burbNWdVUobHf7rBxkKdexuIXG/kim/MggwO
z31bpXyINoyCqAku34j0drOv64tNskBDBsMXc3eDFWj/ytze3selK8M9mwJT
/bGyywcmBoyPkuHjh3j7mgh1HihPP0nHfETAX/JY3tWl7iaXCOBGfXzDUL+x
rU1P5qoenvihUZdluusj2Uvrcl4L+yJnU4++Z54xikBQqGuunYpo5h15Wnfj
J3NpnSc6ECekKpB5k13UWyQYj12FOs9hUuqYBm9BWdGrkELXbJfLotSEOr0h
ayhtSolxSxFq/ZxRpFRB8Z3HJL1rdHvb1XtNDJi3ZsHulMSclxzWLCTU+dyl
RAr1EvXlwXV/+MPY88fgsiUsd2nXZWFHC2rKY6JgKTuUduYIe/PsmVag8xQR
ytvwLPJ6O5k6ZF6ligv1nu2OsW1Mk5v1iK/j4nNQJ17RrNl+gUkNXWuCx1g0
Z3aFNObyXmnbdu99zgtOpTiom5x+NaJsCHWE9LfWUvd9Eye7hweKZvj2RJP5
lPmoL/krp9f8L9vdTqu+vyF6EOm1/rXp1YoS0Vcld7vmPHDHwEZCnd/gGS8V
DH1gg01zXowMgxPC/cP4NlWBJ9r7MKn8WdBhG6cRbsj40rVNahy3hOjZrWo0
XPknreHxf4kNHZ6Yd300vxOyCcwr/N4kxklo+VMjMgTcrvhLXnM1+Sf3qv3X
7tJreE1GcsjcmAepJh7s5M317PuzsOcPkoeHkF7rHqPDs40WYC0A09yf33nK
afZxY36hjqd/at2as88wv4+pL51a1lTnta40vV+V57Xk7q0tTyLzvkW08djH
R51ayeR5DtcpY9bfLe9V6AVMKfvypSfUTSJsU8KydvWBM/laaZ/VFx6IFOo4
qjNHIxs30zuj6tbNOKbbwkKd+yiKOKGuSVrX4RP3du1MRVu3rrW8lWbXH2gn
czMVSq+YGQ3Ellwok3duXDvBsYMO5W0+opH+KKssh54ElCo+5E2JYe0m/Ftw
sGfnpCfcL+V0UNf9wUzodUO4G3FFqr1/KUq3oafsP+yywFY47aAuIoK6+aZd
ZoS6YYtEYHtRzpQQIV+qcp+C1B1XJ7aSrb7tUfDMlNnpuc0Pk3J1lfRf+c2P
uN6r30d2Uenk+8wZBvkF87etUdhdqMufBd3xxgnBrh3sotIJ6L6Ow1MLU2ek
xQ0c4v19x9DJoZ069dhILLxTU1SRZ4WosUm2OxQYieMveaww//zchQO/8QmZ
OmlCl46jNxNKgFJrhpRg+QtCXLy5xixMW7h7A3HPnRyHqbH0vd+GLjMuKz6h
ToR8cfmfGVy9k/rF5bGDCecckeMspRZk3mcX/RZRxmOfqC/Cp4xLzFx2Y0Wv
Qm+8SjlY53hCXczeGYF5oU6AaYuuXkmK2R41dEaIZ5t6hLOZ8V0GthLq6od7
/erz3cQhRkXrYyyYuTyFR6gL2yEnz2NGfrtXSDVR3aCY+Tjp0cp1lNgSRM5Z
dGiS1nw5n3cEpEredKaMaf5OPCgcAIM+fiKuSEWqazpksZCDukhLKFNCXV8+
Mp3MFU6J7r7dVryeBtQlVmIcugShrIt7c4QW6ma6RLmFOj0ucNuhuYPtmlPb
v/8/xiKYHTBnGOR6rOg71EpBqMucBUyTHR5UbeDwPx/bR6UT0J6T4qJM03fW
GO5iw2cWs8ZzXKWkQ+5biRlI7FWoC4/06z+6nY76vAHNsMLf5n1bUcoMi5Pi
Jwd7tj/00OQdPEIdS90Z6MLf+euu9lAo9JISUx3dOobjNigdUkJDCyLfW0yM
R/g2CkHXCymQieQRM+ZuKzC3LpSfuamb9/e/cIWOEe35zKD0hLrJWWyJ5S8o
1DHNnU1rjPenMO2L4/unfqI0eoUo1xejEVyEUC+MnlBvCe8VKmJi4VKvNlcg
vL7oVJcletx/dGVO++HklUx8UFuWZq841F8uM9FslGNRiFeqqOTN5WFNVmTw
lKoYPxOzyRBXpCIvPxVze5T5owo0DibUyXCIzt7Dhv35zCTltEQUPTe3IiXk
joxAx0gahtUpoTox7ucIr7fb7sIjanWUu2QE19u5ozRr1flPea/WFpkkyw2D
2jgWvyRoI6FuryzwxPnHivLzRd6LzAcRhHDEfypV7b9ml3FYM4NQEVduJm63
9MYl9/TQuhV1+XoVU295nSwRkpe6nFprS/kXf2kuENpL4dXlS29v4p9G70/H
dPcmf15RSG/oBhG639DHEOMc4+RaUZfxLaY+22JuJrVoBOfKAnd/a26d0+y6
kG5DilPglakVdUqfMPdryHPBAtpVH9SFQFCoa4uSOrv/xqV8dJEeWVUjeJiU
0nXGe+JmhfqjKwta9zAOPsl8sNnLSfUO6sJuyeSV5ZweJtRpd3HTf43q8oTO
67ME7jkyE9Sd+WLVwdgfKjt5jJDnEhkkRali6fubNeM/KUOvzFu4JEKXtoif
003VzI4kHRhHoNsRaQk6HEuo65cOOO1cP6Ra3+WaTQlZhkIvIn6uEFHCZiA7
f6HDpPzGY7ObScneRugwKdd0EruZMv6bzof+Mo5zgaVuaS54c7F5rDEMqesP
NhLqdsoCVrAmrNGMZSaBx7H7M5svFH+CnhN62ZNzjNYLdTGbmKSBsWIH4UPk
x5U+9vGOzeBwIqHifFq2lSZjr0K2VqZ7j65qhLJMPJ+xcSAvPD3A230rmlUU
WtMrSY71daWXenDx075mpZrVhsRxRPKnhIf194DI9xYO46GGPO4GQgo2OQKv
kXYodJiUf4/VTK+CD8Q1K7k0HhvKIYHoCKtSbkQtJaFOH/pgB4MlbwRT+K9J
4KoCLH/ON0OO6X3DzAj1Y+0q9uEsh5zkyVVZo5KQUKfO1NT85TI7iJawUMc0
N8c3GHpEcC5JdZL8lUXPWAUNktqJc6rNHZ+Z2tA3e0qOWFppO8E0jpYRtIO6
cDdF3ir1+Q99xF+kYgbxy+Cqh3t9PxpzlDdUtZhAiMJQh5TNFikZi8/spIY+
VyIc5cm8EzuNYwl1OuBq02EDzphE6taHD/WJipcjIrSZnhPveOtU4j9o/2/B
YV/XLjKceiY7MS4DI+tR4LC/zYQ6da0h1zyX0vAmwQ2w/OurvuvBGeDi9ZbJ
3wqduRaBNYYhOeaDbYS6PbKAqQ7GtDUNf4eISd/ZH77da+XWP9lHuVXt/+sW
0z6K2jytVm2RPoDk2xd/hvSvWtUj6k/2EUhiNG+v+PTTVUw/T4GDQmSnZ/Hh
FMkljxVuj+77sWuvaOONA477WYjZ9H9M48MYnp+ZMLq6pHgdUuDrAYjZtFBM
hoKo8a59DGkuWNZu4DFuL3qyWkWFYzWHtLdIMh46RAaH+CFjP9Z2i+bbNJcC
eVc11xhNaXj+Mjfn+pJ5uN1U7hNPlIkKxOnlwPZCnfPCo1M7gjlXXIkD134K
L5O7h3By02b2CLvJuvVMWKj/r+nFSYgYmLZ3dGMtcgpceJQdPvgzZ6475gSF
uuZU3FddzYU/ol3p+HbZzEtK/dkW07P5jC/Ri9tjLj/jXivEHufsGxawiAz6
JIh5B3Wt+v66Ff2qmIs3W6K++dOElh+IDiolchmcOFYTzH0OiIZambdqPYEu
0uH8LqOqh6dD+vZpFYzPOs2svVAO6kKTa0mTC8cS6sSq7MmRbQZeNl1VoJ2j
lGJv27E2Jai44ERAC9chXLs8pHfBwNCbzGmgVCvVQ97a1ncY24uMiIDd5gPB
CytFCHX1iT9G11TUkx4jTtflGt0ZRwddbGJ0B6XuWueW9WcdPvngQRab3Pup
13d0/mwpcy3XooKy2DDM+Y5y/MK8UH96Z4dvG0V9aSE6bZwFvJ9Z07FxwMGs
zDt3jGrh71v7/hjblL1qYUkWsII1k5qu5IrnTK0zsKP+8hy6USdtDqrCEXVE
fXB5s6Wmzp9UmD6hkDhm0y2p5PnWeZ7ejvVycQkxDuGC3Tw9vZYrdzvF9Un3
OgGbT7IakUXGww1vD4DX1MwvPzJupySkf9pvNxhCl3nbKfMpZJhK0/CelmVB
0lskGg/leG+yH01dRWRyB6WFHSOh8QZ9XMl4mkDGQf1cyCXAXK9Sos4Y08xw
lZUejerykG7S49zaXqg3bvLzoj7zT+hvTcXUaQnTPnH2Hse1KYB0beH7zi7+
Hf+4mUfHCcTU184t6cJe3iEnVvjEeXEchx84IdQr1O7vO37xomyGNyUuSrf4
1p2axCoiakV9aO9Zk0IMt/HimjNqlo9L1WFcOzu8Ql2rztv6O24wlUeGC/tm
azMSQj9y4nCqoVNatHlBc2ceFylMW3QpLS5wUOMKTh5BAfGMe6+4wNQXji9q
7O3cymvZoQP39AEq8YekXz44dZrfhLBUMWeUMO39GYOr8eyTagvyr2/eNecr
T5euvr+eMndDrn53UlyQKCr+JL9Spd9ORPgRWp7VuwmZ9bE3A6Y6vntKvXqK
lg3n7NyS+URvYZj6fs6F5b8O/bbT+rRsTeHVpZ99vEwwg4XR0+pzXrdheBV5
Pa7Yg1f2FurqwpM9iGZYbURY9ivOcsfb+5Hpfh1XHmHYnvqfG/NnfVvRyUPG
bRfzKSH6luSgbtV6BWxLu1xEDQy6W8NGBXuODTfujiRaKRPs1vkFDVxb/LTg
BhntB9M+P/LHxE9c+0dvERAn2tunI4glA+dB28/xtCDay92SnV/syW+Lu1Wr
MX3/SeouGyLudNiXH3kuOcOepOtWS1jBsowwmudaWFAWGoZkoS7CMPRuHhK9
sGyYBd2+pFAlGPmNWJgFbfH9FbNajh2z93I63SKQNvf2H539FAqX3ka3qOMz
sh+D6gwabvAMV7+4sWpVUK06Px86zzFKEuH4wpuGhZ+/X0CNUMWq7DUr+lUx
ebJkpJW8Oum37+t7L0+j13IxbeHJY780q9F6Nkse6NFcOzX/y2rd5kac06ec
uFk+aZWv58CtiUY5tdR4uHJ1P3U22QPEXzIe04k7ICL9a3rMit+lzzL28unV
6Ji+jVttvm4s4DVXj4W17rQple7o8OH+/KnFjVxc+nKYpcVZkPAWqcaD8yxn
t3/NmjMi9XWE67etrT5sNsd0imdFx1hccCa4l2sHg+DU3SPQwnUAdd0GN+KG
m4S+TcfFGepL+/Be8uAgl8895p+UOqezvVDHdV2BOm/b7+Pb+o2dEj7e18tr
RPC6EykcF5/pweXu7r2/BAQ17Oo7ftqUAX5t52yNMzjpEZeR0eENyS7Lu1bX
btSxC4qSN2cHNN9yR0PcQti/XcuQ3sHBk0M7tmz546TDd40dxw2uL68eng6f
4Pt997Fjpgxs6jV0YXiiYbJglDUTof5vQWJgP+p2SypVdVdeMjlFiL3NCPue
I8h2t4DEh8Sb3iZs7NGQmTvDuRL6vEl3L2UV334+IXPH7vhTrzfMUay6F787
KnBkjwZtqn5OFJdngG94TGTyHZ4MGhKsuTljoKdnL//q7nTGKvn0YCa9639q
fdqxp8+opeEHGb298DPvLpjiV7lK1yCPvvwrybqi6NDhMzJWj6Gi2fRhljm3
RwpRNS24Ipt7erZoFptp6Q6a+sXtrX+wirStz6jFYbvOGC714wvnXhAzgztB
P0bqB18x3zHFPkL9dfyKtsQlhp0aVWBKB8owWC2RRP1P1obfFnQJakEbTOCE
wOhEwU7ARinBx+iUE+uCQzo3pFve2AFb0zI5hDEhM+a1r1y17zDPntvFOxPS
vyZiwS0e8ZW7exv8JQ2DZozZkc4VOKXkzZ8hbQ3xWvV4VPfvyRF7nwgH/ZmL
Z99+nsMt8O8lY6ON7eDh7teOMNfJ0YsuGk/S6bMVAhj5bVpTUBYYxoucHa08
XXr2ETgBhKQaBrk65O3Zr23TOKl7bbbIgv6kHj/G24tWZEGbezNhZtQonxa6
m0n/U6tFk6FzQg9xjn2aV9lr109uSfdMOhM6lyewe0qaHNnc/Nzd6w/4adKe
jBx5IghJKXnVuaSYHkF0unXt8QJXq2c9/PfZ7ejxpoXX0CVzznPm1BrjISEk
jbGtuvu6t2v31Qq2hCBqasbCIXo9EOA3b1d8nvH5BQpdFxSp+7Lvfz3cvxnU
PeZIYgHn/MiKLEh4i2Tj0U2+Vq8PbeU9KGzcuG6DvAO7xxzjrl+rOkZccMbv
mtu2o7sXobVaBHf/Ze+Bx1xZkDzckE8mrOibbxq4u/v5TF63/GqBBWtTksZo
iQO6cNQXh0E46gs3om8mBQQoSV7ttd7KIFEAC7u7vpR/HNFKi26v7Ci1lm2O
IxaUNEpuTfBaXbZ79XKQhTJKOSj5sp8Fh+wY5QCEOgj1UuNNXP/+Z626XAww
AoS67Diilead7T/HukjONsARC0oSJW/OhPS3MpB+KVMOslBGKQclXw6y4JAd
oxyAUAehXkpg/6aPam9t4AKADQh1mTF/X20p8HbfwubbJHvj2BaHLChpPL3y
cxdZ7t4qPcpBFsoo5aDky34WHLFjlAcQ6iDUSwfsdlKXMCtvbAeMAaEuL7iV
dh61rMChGvrbwsTAdocfOtZw5IgFJZHnMQPbHeaN7FomKAdZKKOUg5Iv81lw
yI5RJmwo1LFLuwe4Ojk1aBT/wJGXWbC8iCHVnJyqjY7IE3+0DYS6lWiK/hzZ
fotwKHJAOiDU5YS4BazLZseyUky1e0mXrSbRzEoXRywoaWB56fP6zrj7xvw3
HZZykIUySjko+bKfBYfsGGXDJkL9dfyK9tRluPoIBsbnl0sfIt5Cd2ZQEeKc
9YBhaYKXc1KAULcKrDDup4GJVkedBUwAoS4fjmilWM6ZkGkS47rbHEcsKGm8
LTw9ceBRiaHpHYtykIUySjko+bKfBYfsGGXElq4v5RhCqNf85ez17OysrJwc
sTESAcA2YEXPc4ibUB7eiZgAQh0AAAAAygsg1C2CugNah7ibaADAdlC365IE
glAHAAAAgPIBCHUAeM+Bdg0AAAAAjgkIdQB4z4F2DQAAAACOCQh1AHjPgXYN
AAAAAI4JCHUAeM+Bdg0AAAAAjgkIdQB4z4F2DQAAAACOCQh1AHjPgXYNAAAA
AI4JCHUAeM+Bdg0AAAAAjgkIdQB4z4F2DQAAAACOCQh1AHjPgXYNAAAAAI4J
CHUAeM+Bdg0AAAAAjgkIdQB4z4F2DQAAAACOCQh1AHjPgXYNAAAAAI4JCHUA
eM+Bdg0AAAAAjolUoQ4AAAAAAAAAgH2wkaoHAKBMAO0aAAAAABwTEOoA8J4D
7RoAAAAAHBMQ6gDwngPtGgAAAAAcExDqAPCeA+0aAAAAABwTEOoA8J4D7RoA
AAAAHBMQ6gDwngPtGgAAAAAcExDqAPCeA+0aAAAAABwTEOoWoVU/u51FkZNT
pCnt9ADvN1jR8xzaHrMePdVikn4N7RoAAAAAHBMQ6haRcyKsCh2H3s1t/S2t
xN9jBbuWhexPBYEPyMLLmKlu+osRAsfcKpb0a2jXAAAAAOCYgFC3iJzk0I8s
0OcU2O3ksI+c3KbHvCwx883X8Svaevbyr+5OaTBlJZ8engzatKnv7t6mYVDY
0DXJKYXidb+2+EnKqZ1Tokb5tKCe1MJr6JI55/NeUmuxmCZ/5XeTkh+Zpv15
7Lw2Qknq06aqS/OAhkEzxuy4kKk2l0FLwdTZN5MjV87qFERnQFcIJ1JV76hv
aK4mdpmw6IlpFeVf/KW5JwctmsVmvqaefufU7KZmvsNKzcUDwz5SSrpmzH1s
RO5bjoy92b7kmwpSHtS4Ufx9Qym/jJlSoRcIdQAAAAAoH4BQtwhrhHqJ+vLA
DkpJK5//PtnnUw3/RcOFcW9MvBq0j3JPhwz+XOHkMWJsxj/mnB606rz4+Dlf
ebp09Y3aE3c9n3aTwLRFl9I2dW86NTFTg2GqP1a0r1x/6z1+nV10Z61OqnMk
CdOqMq8fGTWhVUVFmynh5pMkEdW5Yyv9u9WsXGt8dGRyVpaKnp7g5XB+xvim
s6PzixGWd3Wpu3PAlvMCEwVqFbp2zci0xzxJLLk1xp/IZN060ddemM8Gprk+
vAPx/ZZ+xwq4vl6s+vvE2bgeffHKqjYxkmMSoefVw13fEDWuDBpzy3RmgFfW
nbvnfp7bEzejht778w3vKgWhrlXfj5pSbz6HZVK8fhD3rcfk6MijV1Ifqf4l
/gVPf85fGfFH1wc2/e+mkxqZDYR4gTrt6MQmAedemP+q5nb6jjHhfb6ipmLd
wsYm338pf4peFVxcEj25JT2t7Nlx5al0wWmshCxYCKZ5fGDvLwH0VLeF17j1
G++/5sg6Vph/fm7kEO8OHT6rW721p43m4NjjnMQZC4d440lp1869Vq0efvN2
xeeZpuffgr3fuk3btSvjXpYAD0lLM3mJTUvVllnA1BlpcQNDOjcM8HOr3ryX
z+ToRefybGCoAAA4HCDULcIKoa5J2vDdB7q10K7BV16J+83Ta1G18B84jzx0
h7tnVj/a18oD/4ZHaGQ+/7q69t7VTW3aKBp5zDt8knv5vfjpid6Npv0aE1zZ
XPL+Oj39Y8EkIaxo21LfiuKmDyJ5VZAaOqHlBy69l0bdKOQeiAt/m9Fo2oZl
TTycqn20/CrH6jf9xbfpA1qaqYWSN+d6NCTUcnDoXc63GUHPp8yI8KLcOC9n
T645lwGqxp1arjrwlvdrWF7EYOevfZOeGf7JrkK9WHVv/5FVfl3qKQS3h+g5
nTFKl6DoLfnSkmoOfAqQfnnf6B87uDo5ebNKhgNt8f3ls1vV8FycaNiN0ty6
EOXb7nC+jDIUF4cJP7lX7bsiOktvtK8K/hzVbNgRrrYjKQsWp+l57qGe7aoG
Bx+9lUdP1TVPti1v9uMyI9PVXD0W1rrTpjRKmWtzb+3r0+cz50pdImPyxTQK
cWiuJk1o12ff9Ry9/ledOjj1E4Wic6ekv9kmQjcNIZQuE45ms8rW9qVqwyxg
mvzo8KZh4dSOJ6YtTD4yt4GHU4NPI45n2mCeCwCAQwFC3SIsFurqh3v9PHp1
8CW6YtHjRcmpLd1wbe8utMT9JHIUoRF5v4Opjm4fXZNr1DD6ns4th2/1Xs/b
fSt9nM0kid47ULRftV9IlIoDy89cg8vv2jVmHBMcm94WJvk3IDLg2/3sP/xf
e/0g7itiW6PB7NgicwpTUC0zoMZfRY/NQiv5uoV6N7f1KQLfwVJ3BFbCB2vX
macfCz0oeb1bV5Yst4tQx3IjxxE+Vz19JyzdtKqND/57M0K9fo0aFZkipFKr
kD5xl7Nl1BjYxf0jG3m5f9Nk6PRhv46f0tzZXPsqKb4ZFuzyRcO11xibH28L
zwzs06iCot+Oy3IlTZ20OaiKS/CmBL1TFjGd3LK8e1WFYmg40/1JchYs5unt
WC8XlyGsGTSWc36xp5eiHrtFF2Qua9ZqXy7bnooLDvvhTUzhN39DgYXef2xy
L8xoO/Cy8XQen4cOwfs0ZUCftEJGOjMOjvjQjMhtMM0w3bBTqdoyC+qDK78Y
H5nHrgTsesI4/NG1a8w8kQ1SHQDKNSDULcJSoV4YPaHe8rR783Wimu20IAAl
wgWXuClHDuWHc1MLTf6IqQ7G/lDZSWlOpRNoVSldGggulRMPzA3vrzSXJKTf
PuBzBRENdvNU+CdK8ypdx+st8/5j1rfE/I4APZ6aU8t6qPmU8Eq+7ou3xtQa
z+H/b8DctIsmJ6ltMCubdnd9obyDBIX67dVevkkPVY/SM07+ER9/OuXe8yKb
SouS5I3tKgjrMXK7RxGwke148yxr1WdKEVMt0eReXFhHoTDyX8LeXh/urxTc
qRGRBUvRFP0Z1F7xaZ11N9TMf357aHVbfDJVt+7vd/T2hDdz37rrOXyTsEu7
B7gSTWNKcq71KSqMnlZfoWj6/9o797goqv6Pgy8tfD2rvrKXpY9aCGJKeInV
EM1XgIqBcQvBG6iJkoqaSCqPqeSF8C4ZeEnTBJUkEyMTULyURloQooSC+CAB
KiY+grLo7o/ht7Mzs+zsnJk5u+zACt/3n7rLzjlz5sznfM/nfL8LwvW23ujl
KvshfZayyWbN3gc8+4ZE8cWlzr4X7qPHl3S9KmETnpQmDrX+in2zqA9Sq4Cm
z64AAJg3INSNwjihfif3c0e3jHuMqMZMF8MYMARD3IxyRkk75fkk0spi/dr2
K48wrlL9pyZZvim4iBD0zLMoy4rqZoDWRV8QFUuXWQUlnlVgvJE0AlskKErv
CAjeguo9K/tZGr6eEpcB9dfDbFf8yl1PMeDYcqgPZh0csISlkM1XqEtj4UBf
k6geu5O72VqGVDg1v56M2fF1oUlWEuSO0hhLS4SaJe7ePLEx5mQRj6CUUlLW
Ho116WDRf0X8g/9j/4fyceGBmJhTjcexG2qK9w4dmoIc/MwMgPg7BsPMXdwg
A5Ncy/3rxu2ne+tHLb7I8+yQzr1Ba7L4jpxI16sSNqH+/H6bueiYgzaSYJLl
EgAA5goIdaMwQqgTyoIFb0xIzlYSzPsCHf3mIGpQV1N1Y9cb5IsC4VGvvLbd
jgwSeu1Kw1G5DRqx12GKoCubkt8iUXcNjHtE9z1lGM8eXpjgSoYfJ4ZcrcH7
ivruiIS162+G+8qE7TGMWsY1qNM7ERYytp+B5GHRTt1UnOq/PMspoZi/P2pu
7Rsgw1kH1WfucGRbaECoN2DoMU38U9D1ZApoF9k74849MPi7UklKyhiGt3Cm
dSDSCI29lsSBKLz8pYfcf8sePdM73Qm684zAs0Moy2I+fCNeaJaTbvkjXROo
5b+tv086dzMU6yQLAADPOyDUjcJwoU7kHHeV01KT2Q9tv+SMkP+B/iL1YdaW
tN4n1NP7IjL2K5cfucWezOvr8kK9ZQZujz6KD++2VWjmp8PRApekhRHqOLko
URBV+9aO6mBg1Kg4M8xW0KCOc+oTWy3T8L80n6V87nSIFd5X3i2r5o9DMhZW
7jqIKIl6/xudHROi6OKhItYuCQj1BlE9Rt99UxrRkVASC7Fww0AiSUkPLVFL
FfVheppCNoFJiCTZcdcG7ZZW/4HJpeJXq8xKGjklsqhW6DMSGop4aHITmFg9
crg2dXYFAOC5QBKhXpt+KNxrtoeDXD7AvZu1S0alqupsxpd+Lh5hi8PHTXEY
z5O0Sovif3/t+Cp8pHx6xPz5XtPlAd7xp3SShCsqTi/4NJRMAB7o0rkDqXXr
KrOWzx03LmKCje38pPTGrdvHlZfXrQv09l0bv2Hzirgof58VSRl5B+LfpqRX
fe2VNZ8ucPGytx871kb+r8j4R0/Vv7srzM01bIn67zt4zAs+eIknC5mhQv1Z
VYan9aoLpXSbUfuhfNCGCr7YL5mrYSfpP3/PNalAX4sTOamzyB/ieHGFIGrO
7fy+SMAkg2tQJ2Hkq5GvEmanAJ2lkO/6yq9sSNQZBlxog7qQVONXy2hogzp3
l6S+9vIUm01/Yl+99uXOXQc9rfwuYFqOYJ+DUG8Q1WO0HUtzpwhV1cXz3y6J
CgwM+jxhxyUT5rtjO9ZUpUWZm+JWTA4I3xx1PCdfNLehRJKSOr5BTyaKhzcO
fb8tJDjgk3l701IRE3JNRdpE7y4DHTaclTaijobuQEvXDQlVou6a+9d3u4xM
uiUy7ptbqJuiCcrczNUDurweHHSmDCLqANA2kUSoE9VVt87lnFv0Mak3Bg/5
bKPvsmNndRKg/R47+OUXfVF7ebQhuePwz7ZqM/qqbv0Zr/6X1XF0JjdlTfHJ
zMz9KausZWRQOuPvrHl+ScWKejpRBq2U1H8nbtTQHbks7arMPb2sp+WrtKgg
FKUluT9c3DOCdCz0mBnw+aygI3/pJivbMaUzTxYyA4V67dHN1vN1TCm0dQRj
gmVe98jYr+r29Z/mzBvS6ZWP4nUyv2khlAVhPnzGdePR2lMxnAPa/AbGvUpo
XWHq4Ce9IyBoj6F/Grvr6PWUnqG9rqYo9rOBPQwxP2glEGdppszY3YfHrarF
fIV6hXoVvHvhqBGhS9WrdR/57KC9F4QTiRuPsB6j/7dHj6/yH11Z7vuflPRK
BUGWAMs4tX5Id/9t+u4FI2k0feX878ddvms3X7lXTTQQdYXXTgb7d5+M0l3Y
TTAWJgweMO/6navxk4OPaXIJEo/uX4nd5P06SpDzYUqPOhrqHDpWclcdV6Ew
zSzUpWgC60vgUQeANoGU1hcqbiyzmv29/vyjzPo+pLOFbLyP/vH8h8WJQ/ta
spNZNdAHoPRc1tRLp/3MyPffT7lGaNKLrbPtYzly6LdFCupEZPuFXFVDlEVN
f2GZ3vk7zdFOrm+EUJZEzelriYqHGCTUq27sGMg+to+/ZckYMOwCXJZFBjAE
BU2IDBns1kvWzWNuYMpNnug3812DwtHi4HjmGWhJjB2XZsEsUky80Gg8+aVX
U1UXpvQqZsBQe6l23dz9qL8glw/wc7KyEDHYcGHyRrK+Vff477TT6wd2nCC2
YDFLoV64076nd5jvwbxSFXP1miVzO5e1cSbOo05dk6Aeo5dgPbqvil04I5OV
2k7jKjdR1kFmMT525fyZa/fe0z05QhrF+1l6eJy9yzuqJZGU2lHq7RW9ZkYm
+9er4pb0fAE31x/tiundfUu2BKWDVHWVJ48v7dXxg+iYvzC2OIicH6ZaY1n7
mk+oS9YE3S9R85jMNyin2ugLBQDA/JFeqCNnRSbYywrI0P+ICp9SFgiW0ZpS
CJZ9PCc0Bh7rHt6npLyq+tTol9vNiSrjpMBCJcoghTpaaVC/yw1ZGCDUifLo
IOtt7ETimJVxGmMm6KSLdYXXfpo5s3enXosO/cAtYNTEaDYf2EkIGxrPbOK4
2bloy4KYdnsdp/MZtdwkgzqhqr78c7SNSIFUPZi7ZunoOUAup6tlju8l12h3
8T43R6H+pPQwavus9ttNTu0sveKOC5mUjLsmQT3GJDJ94dXpYQV6lmbNFGRp
aRWaeq2pTwxjb7N+q99uTm49OtbKX55MEklJzopk0y16WwVwC8JSc518aMrf
YqOVTPCoqY+w9YjAUQvDIW7HzGUGfJfXQ+eeLipTid4GMrXOkK4bknGeU+mF
uuRNaITM/CkTLKwMAEDroIWEujbDtq5VgFI7SDVCxYJYepVWCGi5RfkHZFZB
uxLL9Ka/R/89dDpH9yUlJNSZBYX+r2ALdeJG5nxbTqhE+8YMENFU4hkCmZcm
NwzYpGg2PyKeeV0YSWxkSJ+ROiY+KkWHOk1pUCfYtqtGVNUZ7t22GGJQp+O9
+k8BUZsa/1ZP8T43R6HOB/W8W+sn9G46WEKdZwBQ/W+CTShm9KIPk1KDkL/t
0gp15BYVY6gWO89Cp6B3XSPJbgjzI6oHP333cU8r92URWXcFC7RdSwt7CbvS
QXNaX6RpAg2VDP/fWHUlAAB4zmkxoc7opcbMJ7TaQYtSOn6u826lFQLfeUzK
XUO5ET742Gftzuij59KLHyHsp0JCXSuc9FqBKdTrFdkzrKd+x3UeMmZRYbmr
zRAomDiCXvJwVCItSLBC340/WfvPP0IhICYJIY6dg66KYthR1kaYzGaCR24f
Fh/2GI40r8w9noP8TQMM6tgbAWiDeoNGqPuNPsUe/8rb+Xf4XND8BnUi7/iw
EPE+f56EOrOOM/lROGE9Rg8AnuSo9Heb7rZiNlnQmzK0+Y13tSiJpOQfXdRv
UrdSZLaR0rOkB5XyXbBMm6boQx/cm9X8WV9M3gTNN5TlX6wY3hFUOgC0EVpO
qHMybNPCsne3aZ8G8BC443IpplBXU/PLyZjBwzS5rRj691qUkHyPLZOEhXrj
0TNdWY4n1JUZu8f2tB09mqsiGTOD8CuDMZmLKBkmdqcnCQwrq0RRdnH+aMFs
crT8wDjdqT3KamzhPG12OKwc7HXVl4LHaqwGr2/Pucu/1mAM6hgZ1A01qCMy
rj8pTVwSz9rpeFqZ6ueRcY/n+pAGdQ3cHI9IniehzgR4DfPw41wT5mFS1HNh
WI0DAYQrCDD/y+etkvwwKWKEiEcP6JP+q5tDpZMwjwOvR4j6AM7unobmF+om
bwJVZnpSV1DpANB2MD+hjjuLigt1EkJVnftnRvzhzTOXh9q/20eTQkTPWimV
UFdUHHPt9wVPMVAcFY1bwp5HqAsLEiQP4j8adUzInUuLZ5woPWWhRB0lxoU5
jocl1DHVNc6OgCFpbUgw11MalBk7B6zj973TtxKxDlLmp6YK5gmhMDehrpZ2
+70QhWBIsA1gBl+TsB6jOplnDDP7OFg1DoRgWoceFWLHySWSlPS0g35GxFKj
PyxOHPbSpF1H7pkkKw4O2oeaZ4ODniGxx08LCHVTN0F5/rD/vx2++K0IVDoA
tBla2vqiE7kStL5wERTqhLJw/0794heE6uHp40t7yvR+Asv6ohfxwBDqVXEL
+2zkPWxlgAFDrEN4veh09Btbctz5c/WYWcLVP2mPh2ixRSacbvdxVInRGowR
zFjRWsz6RMyOgO8B/gOedJZ1bIM65nqqgYy9Z4cMic3jveM4o0IYMxPqzP4F
skUtFFFngpzo58KI5S0PdNvRPSNWsVciSUnPseg/Kxhvr6lI937d5+s09slf
QnGnvIk5NtVLuT1O8nbODtsulXIeN+aSeG4WNR3hjx+perW5mqDMPR3Rf+DO
K+wdSpWi/H41yHYAaL20mFCnNYmuL+Kf/O02MiGVok3qQiIo1FXVGR62+1AG
Y41pkDVnCh4mpeMh+umCRYX6nT+j3/HVTz6p+4dFi5NilrCnaoIjHSbEs6uz
3GWYqUuUNdkLPb7KF6hzJJLUXfeHa1L3Tu2El0BYEKrUO86+MHOcUySlME7K
GgPqrmoQP/Crvcic48OGCZxSZJLkGLAPro+ZCXXyerq/aDU4LBwxEmjBbPoK
oWJ6jJLQQodJm3ILGn9GMyaFDpPyG2ykiv1SfS50mBQ1XdTdPzNhYPiJbH1N
/uT2Ps9g4QpcojBne5FDiFG5yAeWmSHxbVfS7lNI3ASi4NyCtz1+/K9+tkci
K8FJsJA0AADPOS0k1MmEVJoEX9t18xYS5dFz+1pauu9MQ007RPnqtz88pZVh
IkL91OgOgUgBUJy5uAvr/Sgk1O/kbraWIdIFCwt1snpF/5k/CcZj+U0ONIy5
UdBQQVTtWzuqg4VFb3QCZKI4K6qXzOKtgQcLBRNrKGvyItwWpomZHnHC0UxV
qb5TA4VLumBRXfqts52FzGrat7/y5LHToPXDi6llekdA6E2NYWJnfRzb0F5T
ccyl67yT/HmqsZN2CmBuQp24dmL0UnRNHHonAicfoKHXJKbHqIq9qH6mNbxx
x5/1UdxJGWmHHJO0hufPLSOZSYOaY1G7RdSEw01EIzA5lF0I9m7qbgh1Fl42
wmHjBc6jwTwRFu8FXOKGEJgdmRYX6s3QBKL86vb3fZElAp8kLB513JR5vQAA
MDOkF+rIgkfnk4KQEdeainQvV0tHTu0hNbcvfeobUdCohUSF+qvcwkkN5Cvy
8LgerOCzQMGjosgZNu2sgvan6ad6FhTqyvOJg8aLpXdjkkLw7X2LZwgkVFVH
90ztRKp0/oNF2uD2vOx/0HF54m5xSojP+p/zRZWJuEFdpSjZHTup84ueUauF
ynzUKwpWLhzxAk/VV70fJc+v2Vm8xW/LJJTl+9Z5uERM7CS2+8AY1IXyWhiq
ljEtN4qH2WFBVnLBc7W05aZJEWZzE+rqe503b9hnWZxUz8qa7A+9EPnlDBkb
vNckqsfIR3v6yy++tl3vCAl5sMKyL2deUpz5bm53yz7+6GLKAmgmOr1KbUxu
vSEOu67wjgbxJhjdUVRRuYkhbJMbmXTx3Rc4c53ycd7H/v1Wb83/O5/NzZt5
N3NXf2KzjRVGMKaj6irPBAzd8DuiK+h8VjxRCAPKxjHgCHUzbAJZZXtEvxUn
zpaW6t2F2yVZV5M8bDYZkgAWAIDnDemF+uAhq9YHrjujLRdOKC6lLevZTj4f
tRveoNHq/h5W7uO+K9CWiiAUVy5u9GTHE+prL010Vl+Q84ZEhA+cFOrte092
WbBhfZGOfU8tShNcrJdmXEPkUZ85YcWi0MwSRl+qNefmFc5WXUISOSq9gV+o
qxRlB79Rz/OdPooU9mar8tLCu1ogTDXMlVYfiHZqx+OVJVTVf1xKDJg+uL2F
3RSfZJ2CjygIxeXT6wfL24103PrjD7e0CSrVfyQnO3XpMteFIml+tZ8vWT6D
Lxytqiy/euDI6kH2VuNdvjwvVhqeeT1hmrGJiutJnp6vdOgyOWbVmYJi7R8n
qh8UppzY5uk8Z3/yvTpF9rRBL28T2gLW1J0UeS1qs3pinWDVvoj511NMz5DZ
h5w3C9U0oX0+OF53fppbqCuqzvqSj+FLsyOKHvO0raYibeLQ+YlHtGNPVXEr
c8YUq75267g16w0cGwjUC9g968hnp7/D/uv8y8W6yl+CPug4tnGeUf332uEx
wzsGB/+in9NEazM2IpMkcW/fBq+XXvnP8bN0STJF1ZWVEQO62m/8hX9pjNOE
JnQUcf3X6P4dh6+M/qvqKfVzmozfHSfHJbCaTqYBXElu2PGit6g0sqOIB6Wp
U0eExm27XFJJT2Xa80SDUYOE3QO4Qh1rYJhfEzTBKxm6/zWYuHAzAADmRrNY
XyoVZYe+WeDmGrYkcoGLo+PsoN1nznEraTailrtHj23xmeIw3mXBsiXBrm6r
DyaWPGFmuiel33sy6Q01yOS9xnux82bX114IdkooVCpv5CRMHj0idEJQ0OLw
cSNGfLLoxE1943ij9eVxxc+RC138vcPmLZk21HHm55HpBTx15bhC/WllesAk
l86NE6pMbv3FHxwDKvEsL8IfkfXbyye9gvylZ2lf+zrotk63QiVVmN7bUdbZ
ZZJz6JqwpN+yq4UcITrU1dxKPro54CPf/u926Ut2l72PS2R8TGahWOE8Qlmw
fJq9/Qfu3WyZhr3o7Kt76ePf7PXaOD/nOZsiU7NzsK6HUN6MXuLaqfP4KXYT
MaPH6pfsxZ8PLVg1Xe4/smuXd/3Uv+swJWJm7NHEG1XM0uPxnfxKhEIl8k8v
c0RlWndzO1ZSj/8ZXTS3aexYGyqPUOMgZBOoOx74DEiV8cvRieDt7f33pxtq
PW0eof4kOdbN/p133nhvYHsdwcAMDEQGe/UTnXxkzWh1B739dn9bW1fnxbu3
5aJuFikO49aO6dRlYoi932FDdhbKf9/ixOlztYpx0eRH/SQGsYdCXZXbOFtH
8hEbHuS95dgPd1HRaWVu5kobK/uJk+xnCSYvRUMo8i4lTgsba2frqr4SN+fF
cet/Ry6NDWqC0R1Ffbuq/Nc1G2YPsrV9V/MoLZ+XlKO/Y6XNj8oLx2NvfEep
H/Bzp3d+uChwkPp63Mda93ozwCVyT3z+A/7dAkJZtHJW706vRV/kHuHUwcCB
YWZNYJx4ApjiPAUAAGaMQe9oA1/owllfzAbhrC9osCuTAgLUZ+5w/AorcA1g
0uzWF6kwx7FRfeOLcSbOJNl0oKMkoRU0AQCAVgIIdRDqLUZt4uTJF5pWVgZg
02qEujmOjbILk1djJFBqXqCjJKEVNAEAgFYCCHUQ6i0E8TRnzphjWDnzAVxa
iVAnnuXMckooNq84MWZx2GYFOkoaWkETAABoLYBQB6HeMhA3Mjwj0In7AKNp
HUJdPTY85mytNKvH61lVesDoExXmpd2goyShFTQBAIDWg4RCnfjjaHBHC4v+
A5NLzSvgw4Yoi/qQrA03N6oM82BmAwj1JqOs/u2jMQnC2d0Bw2kNQp2sveV5
wLzGBlFzdKPnQcFk/s0PdJQktIImAADQmpBEqD9Jjh0zwM/JijmWbtfN3W9Q
LDcFSstSX/tbqLdu4g4yD0BwCKIsBRcQ6k2CqEpcOS1drL4SYDjPv1A3x7FB
FP8Susz4vO7SAB0lCa2gCQAAtC6ktL60Ykih3n3LhatFRfn5xcW4ORIBQBqI
6gfFZAGUisKohc+5UAcAAAAAQAsIdaOg7PcUyJpEANCM0NV1KQJAqAMAAABA
6wCEOgC0ceC5BgAAAADzBIQ6ALRx4LkGAAAAAPMEhDoAtHHguQYAAAAA8wSE
OgC0ceC5BgAAAADzBIQ6ALRx4LkGAAAAAPMEhDoAtHHguQYAAAAA8wSEOgC0
ceC5BgAAAADzBIQ6ALRx4LkGAAAAAPMEhDoAtHHguQYAAAAA8wSEOgC0ceC5
BgAAAADzBIQ6ALRx4LkGAAAAAPMEhDoAtHHguQYAAAAA8wSEOgC0ceC5BgAA
AADzxFChDgAAAAAAAABA8yDdKgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMC0
/D/7oNmd
    "], {{0, 139.9245283018868}, {675.8490566037735, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{675.8490566037735, 139.9245283018868},
  PlotRange->{{0, 675.8490566037735}, {0, 139.9245283018868}}]], "Text",
 CellChangeTimes->{
  3.9472653419570713`*^9},ExpressionUUID->"a9801838-6d70-da40-ac1d-\
2346a29fb1bd"],

Cell[CellGroupData[{

Cell["X (13) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, 
   3.94644557474518*^9, {3.946643253792639*^9, 3.946643284390875*^9}, {
   3.946746036139828*^9, 3.946746038524223*^9}, {3.946746068669115*^9, 
   3.9467460693399773`*^9}, {3.946746103812231*^9, 3.946746104772272*^9}, {
   3.9467461898531*^9, 3.946746192036283*^9}, {3.946746233828554*^9, 
   3.946746236204479*^9}, 3.946748343513323*^9, 
   3.947219934891445*^9},ExpressionUUID->"e85933b6-4979-c24d-aa11-\
99cf73704e81"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "13", "]"}]}]], "Input",
 CellChangeTimes->{{3.9467442551607094`*^9, 3.946744265127234*^9}, {
  3.947219928684494*^9, 3.9472199377645683`*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"0ba1376c-1520-5a4c-92b5-5db6faad1da1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"10", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"4", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["a", "4"]}], "+", 
          SuperscriptBox["b", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["c", "4"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "6"]}], "-", 
      RowBox[{"9", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"17", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"12", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "9"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"17", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "4"], "+", 
           RowBox[{
            SqrtBox["3"], " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "6"]}], "-", 
      RowBox[{"9", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"17", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"12", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "9"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"17", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["a", "4"]}], "+", 
          SuperscriptBox["b", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["c", "4"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "10"}], " ", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.947219938463022*^9, 3.947219953280428*^9}, 
   3.947220072762945*^9, 3.947568644691744*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"ee4c567f-60b8-4c46-a1f0-0ddef31d73a1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 
  3.9466432738224773`*^9}},ExpressionUUID->"b6799f86-6664-094c-99ef-\
79afc8a62910"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerspectiveQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9},
 CellLabel->"In[54]:=",ExpressionUUID->"55610e76-6e5b-a147-ba83-256232cf290c"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.94756864692902*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"39604896-c41b-874d-9443-bdeccd4a5598"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (14) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, 
   3.94644557474518*^9, {3.946643253792639*^9, 3.946643284390875*^9}, {
   3.946746036139828*^9, 3.946746038524223*^9}, {3.946746068669115*^9, 
   3.9467460693399773`*^9}, {3.946746103812231*^9, 3.946746104772272*^9}, {
   3.9467461898531*^9, 3.946746192036283*^9}, {3.946746233828554*^9, 
   3.946746236204479*^9}, 3.946748343513323*^9, 3.947219934891445*^9, {
   3.9472205809315434`*^9, 
   3.9472205809955673`*^9}},ExpressionUUID->"0817d928-21c0-2845-8bc9-\
11a79fcf7f45"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "14", "]"}]}]], "Input",
 CellChangeTimes->{{3.9467442551607094`*^9, 3.946744265127234*^9}, {
  3.947219928684494*^9, 3.9472199377645683`*^9}, {3.9472205865158615`*^9, 
  3.94722058657226*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"b783a433-965a-4e44-bdf0-c24b51868404"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["a", "4"]}], "+", 
          SuperscriptBox["b", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["c", "4"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "6"]}], "-", 
      RowBox[{"9", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "6"], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"17", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"12", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "-", 
            RowBox[{
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "9"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"17", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "-", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "6"]}], "-", 
      RowBox[{"9", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "6"], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"17", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"12", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "-", 
            RowBox[{
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "9"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"17", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["a", "4"]}], "+", 
          SuperscriptBox["b", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["c", "4"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "10"}], " ", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.947219938463022*^9, 3.947219953280428*^9}, 
   3.947220072762945*^9, 3.947220587407793*^9, 3.9475687335866776`*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"83d2b2b4-4f26-d348-ae18-de074e52562b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 
  3.9466432738224773`*^9}},ExpressionUUID->"8bd983c8-b773-1446-8c58-\
9d9fce10c308"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerspectiveQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9},
 CellLabel->"In[56]:=",ExpressionUUID->"57ac7a59-b5a6-b042-9bee-e346db8eefb2"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, 
   3.947568735259815*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"d0810914-900d-9e4c-bdb3-f899a091084b"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (15) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, 
   3.94644557474518*^9, {3.946643253792639*^9, 3.946643284390875*^9}, {
   3.946746036139828*^9, 3.946746038524223*^9}, {3.946746068669115*^9, 
   3.9467460693399773`*^9}, {3.946746103812231*^9, 3.946746104772272*^9}, {
   3.9467461898531*^9, 3.946746192036283*^9}, {3.946746233828554*^9, 
   3.946746236204479*^9}, 3.946748343513323*^9, 3.947219934891445*^9, {
   3.9472205809315434`*^9, 3.9472205809955673`*^9}, 
   3.947220722468012*^9},ExpressionUUID->"bf08d3da-6bfe-9647-8de8-\
2b79433fe19f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "15", "]"}]}]], "Input",
 CellChangeTimes->{{3.9467442551607094`*^9, 3.946744265127234*^9}, {
  3.947219928684494*^9, 3.9472199377645683`*^9}, {3.9472205865158615`*^9, 
  3.94722058657226*^9}, {3.947220741660054*^9, 3.947220741715954*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"8d50bc02-97be-9d41-8717-230ffa943103"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "-", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"9", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"10", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["b", "2"], " ", "S"}], "-", 
        RowBox[{"4", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "-", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"10", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"4", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"9", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.947219938463022*^9, 3.947219953280428*^9}, 
   3.947220072762945*^9, 3.947220587407793*^9, {3.947220742419802*^9, 
   3.947220756389679*^9}, 3.947265748497076*^9, 3.947568741507063*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"bd793a2d-29e3-614b-b737-b2d87e8f0a93"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 
  3.9466432738224773`*^9}},ExpressionUUID->"1a156b53-dc8b-ec46-aaa3-\
1997f9eb6785"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9},
 CellLabel->"In[58]:=",ExpressionUUID->"8ce40a0f-1452-2b4e-94f9-f1e848ae41f4"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947568743046093*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"5f3b6cf4-27a0-9247-aa03-5f35c425f9cc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,GHEF]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 3.9466432738224773`*^9}, {
  3.947265725944998*^9, 
  3.947265728448883*^9}},ExpressionUUID->"3212cb03-0fa5-5c43-8c48-\
7c6bab515b27"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9, {3.9472657338026924`*^9, 
   3.9472657408652325`*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"403ab7d2-c6a3-ec41-95d8-eb208af613be"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.9472657516633587`*^9},
 CellLabel->"Out[84]=",ExpressionUUID->"e2f7caa1-39fc-8f4d-a004-05528091dcdf"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (16) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, 
   3.94644557474518*^9, {3.946643253792639*^9, 3.946643284390875*^9}, {
   3.946746036139828*^9, 3.946746038524223*^9}, {3.946746068669115*^9, 
   3.9467460693399773`*^9}, {3.946746103812231*^9, 3.946746104772272*^9}, {
   3.9467461898531*^9, 3.946746192036283*^9}, {3.946746233828554*^9, 
   3.946746236204479*^9}, 3.946748343513323*^9, 3.947219934891445*^9, {
   3.9472205809315434`*^9, 3.9472205809955673`*^9}, 3.947220722468012*^9, {
   3.9472209548836823`*^9, 
   3.9472209549152164`*^9}},ExpressionUUID->"7b9d6f3b-edce-994b-905a-\
fe733968e43d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "16", "]"}]}]], "Input",
 CellChangeTimes->{{3.9467442551607094`*^9, 3.946744265127234*^9}, {
  3.947219928684494*^9, 3.9472199377645683`*^9}, {3.9472205865158615`*^9, 
  3.94722058657226*^9}, {3.947220741660054*^9, 3.947220741715954*^9}, {
  3.947220970963372*^9, 3.9472209710436344`*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"0b615984-8d76-e749-b6c1-28e6585f62eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"9", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"10", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["b", "2"], " ", "S"}], "+", 
        RowBox[{"4", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "4"], "+", 
           RowBox[{
            SqrtBox["3"], " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"10", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"4", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "9"}], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "+", 
              RowBox[{
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "+", 
              RowBox[{
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.947219938463022*^9, 3.947219953280428*^9}, 
   3.947220072762945*^9, 3.947220587407793*^9, {3.947220742419802*^9, 
   3.947220756389679*^9}, 3.9472209716857247`*^9, 3.947265416419216*^9, 
   3.9472658096383114`*^9, 3.9475687491031475`*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"262744dd-a654-204c-8246-3f79bff2460e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,GHEF]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 3.9466432738224773`*^9}, {
  3.9472658021129837`*^9, 
  3.947265803872755*^9}},ExpressionUUID->"c80de68b-6810-4a48-bafb-\
64f5299a3bd3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9, {3.947265814514572*^9, 
   3.94726582050482*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"2385d125-7233-7543-9a7d-a65a325ddeda"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, 3.9472654182444534`*^9, 3.947265821379871*^9, 
   3.9475687517589664`*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"033eb9cf-0828-c143-a8a5-c9219f5c9fc8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 
  3.9466432738224773`*^9}},ExpressionUUID->"964972f7-4b04-8a4b-b149-\
e0a5e2581a75"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9},
 CellLabel->"In[61]:=",ExpressionUUID->"2dc9c00a-3225-c246-b918-0472d60b11ad"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, 3.9472654182444534`*^9, 3.9475687560286884`*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"6339bb75-8652-b341-b6ef-d901938460ea"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (17) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, 
   3.94644557474518*^9, {3.946643253792639*^9, 3.946643284390875*^9}, {
   3.946746036139828*^9, 3.946746038524223*^9}, {3.946746068669115*^9, 
   3.9467460693399773`*^9}, {3.946746103812231*^9, 3.946746104772272*^9}, {
   3.9467461898531*^9, 3.946746192036283*^9}, {3.946746233828554*^9, 
   3.946746236204479*^9}, 3.946748343513323*^9, 3.947219934891445*^9, {
   3.9472205809315434`*^9, 3.9472205809955673`*^9}, 3.947220722468012*^9, {
   3.9472209548836823`*^9, 3.9472209549152164`*^9}, {3.947221312588068*^9, 
   3.947221312651436*^9}},ExpressionUUID->"0771c1cb-44c9-b54d-98e6-\
001ad32ebc50"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "17", "]"}]}]], "Input",
 CellChangeTimes->{{3.9467442551607094`*^9, 3.946744265127234*^9}, {
  3.947219928684494*^9, 3.9472199377645683`*^9}, {3.9472205865158615`*^9, 
  3.94722058657226*^9}, {3.947220741660054*^9, 3.947220741715954*^9}, {
  3.947220970963372*^9, 3.9472209710436344`*^9}, {3.9472213155392118`*^9, 
  3.947221367523184*^9}, {3.9472653982009754`*^9, 3.9472653989047623`*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"88775239-2fee-c843-9a7f-8398f299b60f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["a", "8"]}], "-", 
        RowBox[{"15", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "8"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"21", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"21", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"17", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["c", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"37", " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"12", " ", 
            SqrtBox["3"], " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"35", " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"22", " ", 
            SqrtBox["3"], " ", 
            SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"13", " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"19", " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"25", " ", 
               SuperscriptBox["c", "4"]}], "+", 
              RowBox[{"8", " ", 
               SqrtBox["3"], " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{"16", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "6"], "+", 
              RowBox[{
               SqrtBox["3"], " ", 
               SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["a", "4"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["b", "4"]}], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["c", "4"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"], "+", 
          SuperscriptBox["c", "4"], "+", 
          RowBox[{"6", " ", 
           SqrtBox["3"], " ", 
           SuperscriptBox["c", "2"], " ", "S"}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"], "-", 
             RowBox[{
              SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["c", "2"], "+", 
             RowBox[{
              SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "10"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "9"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"8", " ", 
            SqrtBox["3"], " ", 
            SuperscriptBox["c", "2"], " ", "S"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"37", " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"14", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"14", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"20", " ", 
            SuperscriptBox["c", "6"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"34", " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"9", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"69", " ", 
               SuperscriptBox["c", "4"]}], "+", 
              RowBox[{"36", " ", 
               SqrtBox["3"], " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], 
        "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"11", " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"10", " ", 
               SuperscriptBox["c", "4"]}], "+", 
              RowBox[{"3", " ", 
               SqrtBox["3"], " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
           RowBox[{"12", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["c", "6"]}], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", 
               SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}], 
        "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            SuperscriptBox["b", "8"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"49", " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"10", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"20", " ", 
               SuperscriptBox["c", "4"]}], "+", 
              RowBox[{"7", " ", 
               SqrtBox["3"], " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"83", " ", 
               SuperscriptBox["c", "6"]}], "+", 
              RowBox[{"42", " ", 
               SqrtBox["3"], " ", 
               SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "-", 
           RowBox[{"6", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["c", "8"]}], "+", 
              RowBox[{"4", " ", 
               SqrtBox["3"], " ", 
               SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "12"}], " ", 
       SuperscriptBox["a", "10"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"45", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         SuperscriptBox["c", "4"], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "64"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"74", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"21", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"7", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"60", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"7", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"39", " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"17", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "8"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"29", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"5", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"13", " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"41", " ", 
             SuperscriptBox["c", "6"]}], "+", 
            RowBox[{"27", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "11"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{"10", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"17", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"9", " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", 
            SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"15", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"6", " ", 
            SqrtBox["3"], " ", 
            SuperscriptBox["c", "2"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "20"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"4", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"9", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"22", " ", 
            SqrtBox["3"], " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "30"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"23", " ", 
               SuperscriptBox["c", "4"]}], "-", 
              RowBox[{"10", " ", 
               SqrtBox["3"], " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "10"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "16"}], " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"37", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"14", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"14", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"20", " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"34", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"9", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"69", " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"36", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "8"], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"11", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"10", " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "6"]}], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], " ", 
          SuperscriptBox["b", "8"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"4", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"49", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"10", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"20", " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"7", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"83", " ", 
             SuperscriptBox["c", "6"]}], "+", 
            RowBox[{"42", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"12", " ", 
       SuperscriptBox["a", "10"]}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"11", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"48", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"15", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"15", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "21"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"23", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"11", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "15"}], " ", 
          SuperscriptBox["b", "8"]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["c", "8"]}], "+", 
         RowBox[{"16", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "6"], " ", "S"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"31", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"5", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "91"}], " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"18", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"14", " ", 
             SuperscriptBox["c", "6"]}], "-", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", 
           SuperscriptBox["a", "4"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["b", "4"]}], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["c", "4"]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          SuperscriptBox["b", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "+", 
          RowBox[{"2", " ", 
           SqrtBox["3"], " ", 
           SuperscriptBox["c", "2"], " ", "S"}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"], "+", 
             RowBox[{
              SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "11"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"11", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"3", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"4", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"8", " ", 
            SqrtBox["3"], " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "5"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"7", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["c", "4"]}], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "8"], "-", 
      RowBox[{"6", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "S"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"], "-", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         SuperscriptBox["c", "6"], "+", 
         RowBox[{"3", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         SuperscriptBox["c", "4"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["b", "4"], " ", "S"}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.947219938463022*^9, 3.947219953280428*^9}, 
   3.947220072762945*^9, 3.947220587407793*^9, {3.947220742419802*^9, 
   3.947220756389679*^9}, 3.9472209716857247`*^9, {3.947221316903416*^9, 
   3.947221368211802*^9}, 3.947265400337639*^9, 3.9475687614648647`*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"dad3e87c-ab21-7544-b7c5-96dd2e0b4d9d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 
  3.9466432738224773`*^9}},ExpressionUUID->"0bd7089a-d088-e945-9a0b-\
5a99effe3815"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9},
 CellLabel->"In[63]:=",ExpressionUUID->"59ad04e9-8d9b-1d4b-a233-463fc1cd65b9"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, {3.947221320534374*^9, 3.947221370088148*^9}, 
   3.947265407648958*^9, 3.9475687640577393`*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"8faabeb2-977b-d44c-9dfa-527f8d9456a2"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (18) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, 
   3.94644557474518*^9, {3.946643253792639*^9, 3.946643284390875*^9}, {
   3.946746036139828*^9, 3.946746038524223*^9}, {3.946746068669115*^9, 
   3.9467460693399773`*^9}, {3.946746103812231*^9, 3.946746104772272*^9}, {
   3.9467461898531*^9, 3.946746192036283*^9}, {3.946746233828554*^9, 
   3.946746236204479*^9}, 3.946748343513323*^9, 3.947219934891445*^9, {
   3.947220580931544*^9, 3.947220580995568*^9}, 3.947220722468012*^9, {
   3.9472209548836827`*^9, 3.947220954915217*^9}, {3.947221312588068*^9, 
   3.947221312651436*^9}, {3.9472653803364296`*^9, 
   3.94726538040098*^9}},ExpressionUUID->"dd3e2713-095d-5549-a63d-\
dc48bfff3c58"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "18", "]"}]}]], "Input",
 CellChangeTimes->{{3.9467442551607094`*^9, 3.946744265127234*^9}, {
   3.947219928684494*^9, 3.9472199377645683`*^9}, {3.9472205865158615`*^9, 
   3.94722058657226*^9}, {3.947220741660054*^9, 3.947220741715954*^9}, {
   3.947220970963372*^9, 3.9472209710436344`*^9}, {3.9472213155392118`*^9, 
   3.947221367523184*^9}, {3.9472653867689705`*^9, 3.947265388568966*^9}, 
   3.947265425760828*^9},
 CellLabel->"In[64]:=",ExpressionUUID->"ce24270c-cc23-3a43-b17d-2194b46daa3a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["a", "8"]}], "-", 
        RowBox[{"15", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "8"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["c", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"21", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"21", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "17"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"37", " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"12", " ", 
            SqrtBox["3"], " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "35"}], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"22", " ", 
            SqrtBox["3"], " ", 
            SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "13"}], " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"38", " ", 
               SuperscriptBox["c", "2"]}], "-", 
              RowBox[{"4", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
           RowBox[{"16", " ", 
            SuperscriptBox["c", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "-", 
              RowBox[{
               SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "25"}], " ", 
               SuperscriptBox["c", "4"]}], "+", 
              RowBox[{"8", " ", 
               SqrtBox["3"], " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"6", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "-", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"], "+", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "10"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "9"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"16", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"8", " ", 
            SqrtBox["3"], " ", 
            SuperscriptBox["c", "2"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "37"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"14", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"14", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"20", " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "68"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"18", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"69", " ", 
               SuperscriptBox["c", "4"]}], "-", 
              RowBox[{"36", " ", 
               SqrtBox["3"], " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], 
        "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["c", "2"]}], "-", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "11"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"10", " ", 
               SuperscriptBox["c", "4"]}], "-", 
              RowBox[{"3", " ", 
               SqrtBox["3"], " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "60"}], " ", 
               SuperscriptBox["c", "6"]}], "+", 
              RowBox[{"24", " ", 
               SqrtBox["3"], " ", 
               SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}], 
        "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            SuperscriptBox["b", "8"]}], "-", 
           RowBox[{"30", " ", 
            SuperscriptBox["c", "8"]}], "+", 
           RowBox[{"24", " ", 
            SqrtBox["3"], " ", 
            SuperscriptBox["c", "6"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "6"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "49"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"10", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"20", " ", 
               SuperscriptBox["c", "4"]}], "-", 
              RowBox[{"7", " ", 
               SqrtBox["3"], " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "83"}], " ", 
               SuperscriptBox["c", "6"]}], "+", 
              RowBox[{"42", " ", 
               SqrtBox["3"], " ", 
               SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"12", " ", 
       SuperscriptBox["a", "10"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "45"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         SuperscriptBox["c", "4"], "-", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"32", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "37"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"21", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"7", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "60"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"7", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"39", " ", 
             SuperscriptBox["c", "4"]}], "-", 
            RowBox[{"17", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "8"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["c", "8"]}], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "6"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "29"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"5", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"13", " ", 
             SuperscriptBox["c", "4"]}], "-", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "41"}], " ", 
             SuperscriptBox["c", "6"]}], "+", 
            RowBox[{"27", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "8"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{"10", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"17", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"9", " ", 
            SuperscriptBox["c", "6"]}], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", 
            SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "11"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "+", 
              RowBox[{
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"15", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"6", " ", 
            SqrtBox["3"], " ", 
            SuperscriptBox["c", "2"], " ", "S"}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "9"}], " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"22", " ", 
            SqrtBox["3"], " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"15", " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{
               SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"23", " ", 
               SuperscriptBox["c", "4"]}], "+", 
              RowBox[{"10", " ", 
               SqrtBox["3"], " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "10"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "9"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"8", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "37"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"14", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"14", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"20", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "68"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"18", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"69", " ", 
             SuperscriptBox["c", "4"]}], "-", 
            RowBox[{"36", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "8"], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "11"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"10", " ", 
             SuperscriptBox["c", "4"]}], "-", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "60"}], " ", 
             SuperscriptBox["c", "6"]}], "+", 
            RowBox[{"24", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "8"]}], "-", 
         RowBox[{"30", " ", 
          SuperscriptBox["c", "8"]}], "+", 
         RowBox[{"24", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "6"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "49"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"10", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"20", " ", 
             SuperscriptBox["c", "4"]}], "-", 
            RowBox[{"7", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "83"}], " ", 
             SuperscriptBox["c", "6"]}], "+", 
            RowBox[{"42", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "12"}], " ", 
       SuperscriptBox["a", "10"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"11", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"48", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"15", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "30"}], " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{"48", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"16", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"42", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"46", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["c", "4"]}], "-", 
            RowBox[{"11", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"15", " ", 
          SuperscriptBox["b", "8"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"4", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"31", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"5", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"91", " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"18", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"14", " ", 
             SuperscriptBox["c", "6"]}], "+", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"], "-", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"11", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["c", "2"]}], "-", 
              RowBox[{"4", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"]}], "-", 
              RowBox[{"3", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["c", "6"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"11", " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"2", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "6"]}], "-", 
           RowBox[{"8", " ", 
            SqrtBox["3"], " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"7", " ", 
               SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "6"}], " ", 
               SuperscriptBox["c", "4"]}], "+", 
              RowBox[{"4", " ", 
               SqrtBox["3"], " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "-", 
      RowBox[{"6", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "S"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"], "+", 
         RowBox[{
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         SuperscriptBox["c", "4"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         SuperscriptBox["c", "6"], "-", 
         RowBox[{"3", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "8"], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "5"}], " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         SuperscriptBox["c", "6"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"4", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "7"}], " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["b", "4"], " ", "S"}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "-", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      SuperscriptBox["a", "8"], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"6", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.947219938463022*^9, 3.947219953280428*^9}, 
   3.947220072762945*^9, 3.947220587407793*^9, {3.947220742419802*^9, 
   3.947220756389679*^9}, 3.9472209716857247`*^9, {3.947221316903416*^9, 
   3.947221368211802*^9}, 3.947265426945291*^9, 3.947568770391712*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"bb43c62c-1543-4e4d-a26e-ab4a0535f9f1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 
  3.9466432738224773`*^9}},ExpressionUUID->"cab71017-c4a1-024f-a1c6-\
bcf6549a3a86"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9},
 CellLabel->"In[65]:=",ExpressionUUID->"40898263-cf38-554e-a46a-da43befd8d0e"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, {3.947221320534374*^9, 3.947221370088148*^9}, 
   3.947265430733423*^9, 3.9475687731381893`*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"391004d2-6a80-1144-bea7-0dfaec91156b"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (61) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, 
   3.94644557474518*^9, {3.946643253792639*^9, 3.946643284390875*^9}, {
   3.946746036139828*^9, 3.946746038524223*^9}, {3.946746068669115*^9, 
   3.9467460693399773`*^9}, {3.946746103812231*^9, 3.946746104772272*^9}, {
   3.9467461898531*^9, 3.946746192036283*^9}, {3.946746233828554*^9, 
   3.946746236204479*^9}, 3.946748343513323*^9, 3.947219934891445*^9, {
   3.947220580931544*^9, 3.947220580995568*^9}, 3.947220722468012*^9, {
   3.9472209548836827`*^9, 3.947220954915217*^9}, {3.947221312588068*^9, 
   3.947221312651436*^9}, {3.9472653803364296`*^9, 3.94726538040098*^9}, {
   3.9472654506485214`*^9, 
   3.9472654506976852`*^9}},ExpressionUUID->"96736451-1f3d-a348-bbb8-\
89151889b696"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "61", "]"}]}]], "Input",
 CellChangeTimes->{{3.9467442551607094`*^9, 3.946744265127234*^9}, {
   3.947219928684494*^9, 3.9472199377645683`*^9}, {3.9472205865158615`*^9, 
   3.94722058657226*^9}, {3.947220741660054*^9, 3.947220741715954*^9}, {
   3.947220970963372*^9, 3.9472209710436344`*^9}, {3.9472213155392118`*^9, 
   3.947221367523184*^9}, {3.9472653867689705`*^9, 3.947265388568966*^9}, 
   3.947265425760828*^9, {3.947265455881569*^9, 3.9472654573209686`*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"ef5af8d3-6c93-0743-80ce-95afb42eabc9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"10", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "6"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"9", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"26", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "15"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"8", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"9", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"10", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"14", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "6"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"8", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "6"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "9"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"26", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "15"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"8", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"9", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"10", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"20", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"21", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "15"}], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"20", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"4", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"9", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "S"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"4", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "6"}], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.947219938463022*^9, 3.947219953280428*^9}, 
   3.947220072762945*^9, 3.947220587407793*^9, {3.947220742419802*^9, 
   3.947220756389679*^9}, 3.9472209716857247`*^9, {3.947221316903416*^9, 
   3.947221368211802*^9}, 3.947265426945291*^9, 3.9472654581336823`*^9, 
   3.947265857991198*^9, 3.947568780157181*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"62292834-e61f-6f4b-aba6-3cc05b5b0cbd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 
  3.9466432738224773`*^9}},ExpressionUUID->"bbb78902-ed6c-5442-8464-\
462883d5a0a9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9},
 CellLabel->"In[67]:=",ExpressionUUID->"f69449a8-a60b-a74c-8da1-7a2f799dfa88"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, {3.947221320534374*^9, 3.947221370088148*^9}, 
   3.947265430733423*^9, 3.94726546194742*^9, 3.9475687824027863`*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"9bde4b31-a9d0-9c43-b8dd-2c9c1834f1a6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,GHEF]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 3.9466432738224773`*^9}, {
  3.9472658688484535`*^9, 
  3.947265870841055*^9}},ExpressionUUID->"a15e7bc5-acf7-0e44-b205-\
0db0079ec5a4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9, {3.9472658768246593`*^9, 
   3.947265882057194*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"ff0464f4-595a-6a41-b22f-6092aaf29bde"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, {3.947221320534374*^9, 3.947221370088148*^9}, 
   3.947265430733423*^9, 3.94726546194742*^9, 3.9472658830726433`*^9, 
   3.947568784183981*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"e77cbaec-a850-044f-a661-86c3dfc68461"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (62) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, 
   3.94644557474518*^9, {3.946643253792639*^9, 3.946643284390875*^9}, {
   3.946746036139828*^9, 3.946746038524223*^9}, {3.946746068669115*^9, 
   3.9467460693399773`*^9}, {3.946746103812231*^9, 3.946746104772272*^9}, {
   3.9467461898531*^9, 3.946746192036283*^9}, {3.946746233828554*^9, 
   3.946746236204479*^9}, 3.946748343513323*^9, 3.947219934891445*^9, {
   3.947220580931544*^9, 3.947220580995568*^9}, 3.947220722468012*^9, {
   3.9472209548836827`*^9, 3.947220954915217*^9}, {3.947221312588068*^9, 
   3.947221312651436*^9}, {3.9472653803364296`*^9, 3.94726538040098*^9}, {
   3.947265472225422*^9, 
   3.9472654723134327`*^9}},ExpressionUUID->"1a13ed80-5b8b-2945-9a6a-\
513533df2585"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "62", "]"}]}]], "Input",
 CellChangeTimes->{{3.9467442551607094`*^9, 3.946744265127234*^9}, {
   3.947219928684494*^9, 3.9472199377645683`*^9}, {3.9472205865158615`*^9, 
   3.94722058657226*^9}, {3.947220741660054*^9, 3.947220741715954*^9}, {
   3.947220970963372*^9, 3.9472209710436344`*^9}, {3.9472213155392118`*^9, 
   3.947221367523184*^9}, {3.9472653867689705`*^9, 3.947265388568966*^9}, 
   3.947265425760828*^9, {3.947265477513033*^9, 3.947265479409172*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"29194881-88da-744f-badb-03ee5846f760"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"10", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "6"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"9", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"26", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"15", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"8", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "9"}], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"10", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"14", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "6"}], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"8", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "6"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"9", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"26", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"15", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"8", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "9"}], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"10", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"20", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "21"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"15", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"20", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"4", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "9"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"4", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.947219938463022*^9, 3.947219953280428*^9}, 
   3.947220072762945*^9, 3.947220587407793*^9, {3.947220742419802*^9, 
   3.947220756389679*^9}, 3.9472209716857247`*^9, {3.947221316903416*^9, 
   3.947221368211802*^9}, 3.947265426945291*^9, 3.947265480018751*^9, 
   3.94726592891819*^9, 3.947568788771721*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"a97d50e9-8d29-5a4b-8291-cd67d7094977"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 
  3.9466432738224773`*^9}},ExpressionUUID->"ba7b1b8a-d2c5-8d4f-be3c-\
7a80e169f4cc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9},
 CellLabel->"In[70]:=",ExpressionUUID->"388070c6-65cc-f648-8028-5677491106df"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, {3.947221320534374*^9, 3.947221370088148*^9}, 
   3.947265430733423*^9, 3.947265482951071*^9, 3.9472659322369404`*^9, 
   3.947568790541895*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"00afaa05-4c09-ae4d-bda4-0e8a929f0412"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,GHEF]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 3.9466432738224773`*^9}, {
  3.94726591262504*^9, 
  3.9472659141929417`*^9}},ExpressionUUID->"ef029af8-ff8e-cf49-9c11-\
0bb0848a4b5c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9, {3.947265918376892*^9, 
   3.947265924193695*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"e0c70e38-fd2b-4444-90e8-5bbe598d3dfc"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, {3.947221320534374*^9, 3.947221370088148*^9}, 
   3.947265430733423*^9, 3.947265482951071*^9, 3.947265933895578*^9, 
   3.9475687922560024`*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"1a536f67-1681-3e4d-a35c-17421dfde84e"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (371) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, 
   3.94644557474518*^9, {3.946643253792639*^9, 3.946643284390875*^9}, {
   3.946746036139828*^9, 3.946746038524223*^9}, {3.946746068669115*^9, 
   3.9467460693399773`*^9}, {3.946746103812231*^9, 3.946746104772272*^9}, {
   3.9467461898531*^9, 3.946746192036283*^9}, {3.946746233828554*^9, 
   3.946746236204479*^9}, 3.946748343513323*^9, 3.947219934891445*^9, {
   3.947220580931544*^9, 3.947220580995568*^9}, 3.947220722468012*^9, {
   3.9472209548836827`*^9, 3.947220954915217*^9}, {3.947221312588068*^9, 
   3.947221312651436*^9}, {3.9472653803364296`*^9, 3.94726538040098*^9}, {
   3.947265472225422*^9, 
   3.9472654978165493`*^9}},ExpressionUUID->"3c4edcb1-85a4-384d-8207-\
13cca9b10ca6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "371", "]"}]}]], "Input",
 CellChangeTimes->{{3.9467442551607094`*^9, 3.946744265127234*^9}, {
   3.947219928684494*^9, 3.9472199377645683`*^9}, {3.9472205865158615`*^9, 
   3.94722058657226*^9}, {3.947220741660054*^9, 3.947220741715954*^9}, {
   3.947220970963372*^9, 3.9472209710436344`*^9}, {3.9472213155392118`*^9, 
   3.947221367523184*^9}, {3.9472653867689705`*^9, 3.947265388568966*^9}, 
   3.947265425760828*^9, {3.947265477513033*^9, 3.947265504664564*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"dfb497bd-670d-2a42-857a-b14152fcc539"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"6", " ", "S"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"6", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"6", " ", "S"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"6", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"2", " ", "S"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"2", " ", "S"}]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.947219938463022*^9, 3.947219953280428*^9}, 
   3.947220072762945*^9, 3.947220587407793*^9, {3.947220742419802*^9, 
   3.947220756389679*^9}, 3.9472209716857247`*^9, {3.947221316903416*^9, 
   3.947221368211802*^9}, 3.947265426945291*^9, {3.947265480018751*^9, 
   3.947265505507498*^9}, 3.9472659993719807`*^9, 3.947568797846651*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"cb6c1a04-4607-3046-96cc-6486cd414f5a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 
  3.9466432738224773`*^9}},ExpressionUUID->"3ded466f-a874-0446-aa27-\
423e453e179f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9},
 CellLabel->"In[73]:=",ExpressionUUID->"2c166ff1-8cff-d54a-98ef-75e1774a2718"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, {3.947221320534374*^9, 3.947221370088148*^9}, 
   3.947265430733423*^9, {3.947265482951071*^9, 3.947265508010603*^9}, 
   3.947266001011633*^9, 3.9475687992848377`*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"d94f0fce-e1f4-0d47-ba6c-b0a578ad3c43"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,GHEF]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 3.9466432738224773`*^9}, {
  3.9472659844648647`*^9, 
  3.9472659860640793`*^9}},ExpressionUUID->"c548776f-e5b8-5447-b31a-\
12fbcac20cc1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9, {3.94726599040946*^9, 
   3.947265995977247*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"5e4c3c15-a269-0f43-9814-5100bc2199d2"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, {3.947221320534374*^9, 3.947221370088148*^9}, 
   3.947265430733423*^9, {3.947265482951071*^9, 3.947265508010603*^9}, 
   3.9472660026595116`*^9, 3.947568800515684*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"9f447abc-c912-3144-96cb-a5c5df3e9047"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (372) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, 
   3.94644557474518*^9, {3.946643253792639*^9, 3.946643284390875*^9}, {
   3.946746036139828*^9, 3.946746038524223*^9}, {3.946746068669115*^9, 
   3.9467460693399773`*^9}, {3.946746103812231*^9, 3.946746104772272*^9}, {
   3.9467461898531*^9, 3.946746192036283*^9}, {3.946746233828554*^9, 
   3.946746236204479*^9}, 3.946748343513323*^9, 3.947219934891445*^9, {
   3.947220580931544*^9, 3.947220580995568*^9}, 3.947220722468012*^9, {
   3.9472209548836827`*^9, 3.947220954915217*^9}, {3.947221312588068*^9, 
   3.947221312651436*^9}, {3.9472653803364296`*^9, 3.94726538040098*^9}, {
   3.947265472225422*^9, 
   3.9472655177446136`*^9}},ExpressionUUID->"1cc95522-848b-c547-8511-\
97120e418ea3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "372", "]"}]}]], "Input",
 CellChangeTimes->{{3.9467442551607094`*^9, 3.946744265127234*^9}, {
   3.947219928684494*^9, 3.9472199377645683`*^9}, {3.9472205865158615`*^9, 
   3.94722058657226*^9}, {3.947220741660054*^9, 3.947220741715954*^9}, {
   3.947220970963372*^9, 3.9472209710436344`*^9}, {3.9472213155392118`*^9, 
   3.947221367523184*^9}, {3.9472653867689705`*^9, 3.947265388568966*^9}, 
   3.947265425760828*^9, {3.947265477513033*^9, 3.947265520744892*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"6aff5b5e-3bb5-464f-9a0d-97f513a11f05"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"6", " ", "S"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"6", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"6", " ", "S"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"6", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.947219938463022*^9, 3.947219953280428*^9}, 
   3.947220072762945*^9, 3.947220587407793*^9, {3.947220742419802*^9, 
   3.947220756389679*^9}, 3.9472209716857247`*^9, {3.947221316903416*^9, 
   3.947221368211802*^9}, 3.947265426945291*^9, {3.947265480018751*^9, 
   3.9472655213147736`*^9}, 3.9472660478601055`*^9, 3.9475688061308327`*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"2bc4b71f-5f68-3b40-a056-cb295b4c706d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 
  3.9466432738224773`*^9}},ExpressionUUID->"f9f5dbc7-7b4e-394d-b030-\
151df7dd0c17"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9},
 CellLabel->"In[76]:=",ExpressionUUID->"4df08a76-a241-884f-902f-046c49002940"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, {3.947221320534374*^9, 3.947221370088148*^9}, 
   3.947265430733423*^9, {3.947265482951071*^9, 3.947265522962046*^9}, 
   3.947266049236767*^9, 3.947568807652899*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"aa8dbc00-acfd-3b44-bc50-b70a43abf83d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,GHEF]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 3.9466432738224773`*^9}, {
  3.947266032393158*^9, 
  3.947266034057808*^9}},ExpressionUUID->"3f9f5e3d-248e-364d-8690-\
ac6aa2a2b1d5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9, {3.9472660383295116`*^9, 
   3.9472660443364296`*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"c937897d-8a74-c941-8eb3-13d20b252476"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, {3.947221320534374*^9, 3.947221370088148*^9}, 
   3.947265430733423*^9, {3.947265482951071*^9, 3.947265522962046*^9}, 
   3.947266050626198*^9, 3.947568808659504*^9},
 CellLabel->"Out[77]=",ExpressionUUID->"56fb7123-0ccb-ab42-92a4-4aef5c5a1ad9"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (395) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, 
   3.94644557474518*^9, {3.946643253792639*^9, 3.946643284390875*^9}, {
   3.946746036139828*^9, 3.946746038524223*^9}, {3.946746068669115*^9, 
   3.9467460693399773`*^9}, {3.946746103812231*^9, 3.946746104772272*^9}, {
   3.9467461898531*^9, 3.946746192036283*^9}, {3.946746233828554*^9, 
   3.946746236204479*^9}, 3.946748343513323*^9, 3.947219934891445*^9, {
   3.947220580931544*^9, 3.947220580995568*^9}, 3.947220722468012*^9, {
   3.9472209548836827`*^9, 3.947220954915217*^9}, {3.947221312588068*^9, 
   3.947221312651436*^9}, {3.9472653803364296`*^9, 3.94726538040098*^9}, {
   3.947265472225422*^9, 3.9472654978165493`*^9}, {3.9472655399048023`*^9, 
   3.9472655403291607`*^9}},ExpressionUUID->"943f594d-0a92-9245-93b9-\
c77dfa7c65ea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "395", "]"}]}]], "Input",
 CellChangeTimes->{{3.9467442551607094`*^9, 3.946744265127234*^9}, {
   3.947219928684494*^9, 3.9472199377645683`*^9}, {3.9472205865158615`*^9, 
   3.94722058657226*^9}, {3.947220741660054*^9, 3.947220741715954*^9}, {
   3.947220970963372*^9, 3.9472209710436344`*^9}, {3.9472213155392118`*^9, 
   3.947221367523184*^9}, {3.9472653867689705`*^9, 3.947265388568966*^9}, 
   3.947265425760828*^9, {3.947265477513033*^9, 3.947265504664564*^9}, {
   3.9472655436655045`*^9, 3.9472655456886253`*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"c8870c0d-0cad-bb42-9b32-951d517f0a87"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"4", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", "S"}], ",", 
     RowBox[{
      RowBox[{"6", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"6", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"8", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", "S"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"6", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"6", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"8", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", "S"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", "S"}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"4", " ", "S"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SqrtBox["3"], " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{"2", " ", "S"}]}], ",", 
     RowBox[{
      RowBox[{
       SqrtBox["3"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      RowBox[{"2", " ", "S"}]}], ",", 
     RowBox[{
      RowBox[{
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", "S"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.947219938463022*^9, 3.947219953280428*^9}, 
   3.947220072762945*^9, 3.947220587407793*^9, {3.947220742419802*^9, 
   3.947220756389679*^9}, 3.9472209716857247`*^9, {3.947221316903416*^9, 
   3.947221368211802*^9}, 3.947265426945291*^9, {3.947265480018751*^9, 
   3.947265505507498*^9}, 3.947265546463255*^9, 3.947568813615795*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"eec0756f-3b2a-d242-a958-04fe18a20ff7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 
  3.9466432738224773`*^9}},ExpressionUUID->"21c20a9a-5b4e-0149-b217-\
9448c9719f75"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9},
 CellLabel->"In[79]:=",ExpressionUUID->"917b9a8d-aabf-8448-b7e6-364990783941"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, {3.947221320534374*^9, 3.947221370088148*^9}, 
   3.947265430733423*^9, {3.947265482951071*^9, 3.947265508010603*^9}, 
   3.947265548195416*^9, 3.9475688148921833`*^9},
 CellLabel->"Out[79]=",ExpressionUUID->"e957f1fb-a8a9-9840-b2c1-127d54983578"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (396) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, 
   3.94644557474518*^9, {3.946643253792639*^9, 3.946643284390875*^9}, {
   3.946746036139828*^9, 3.946746038524223*^9}, {3.946746068669115*^9, 
   3.9467460693399773`*^9}, {3.946746103812231*^9, 3.946746104772272*^9}, {
   3.9467461898531*^9, 3.946746192036283*^9}, {3.946746233828554*^9, 
   3.946746236204479*^9}, 3.946748343513323*^9, 3.947219934891445*^9, {
   3.947220580931544*^9, 3.947220580995568*^9}, 3.947220722468012*^9, {
   3.9472209548836827`*^9, 3.947220954915217*^9}, {3.947221312588068*^9, 
   3.947221312651436*^9}, {3.9472653803364296`*^9, 3.94726538040098*^9}, {
   3.947265472225422*^9, 3.9472654978165493`*^9}, {3.947265553760582*^9, 
   3.947265554560465*^9}},ExpressionUUID->"7ac133ce-b73f-054c-8461-\
bcf4bf40478a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "396", "]"}]}]], "Input",
 CellChangeTimes->{{3.9467442551607094`*^9, 3.946744265127234*^9}, {
   3.947219928684494*^9, 3.9472199377645683`*^9}, {3.9472205865158615`*^9, 
   3.94722058657226*^9}, {3.947220741660054*^9, 3.947220741715954*^9}, {
   3.947220970963372*^9, 3.9472209710436344`*^9}, {3.9472213155392118`*^9, 
   3.947221367523184*^9}, {3.9472653867689705`*^9, 3.947265388568966*^9}, 
   3.947265425760828*^9, {3.947265477513033*^9, 3.947265504664564*^9}, {
   3.947265558337105*^9, 3.947265559121172*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"763159cc-f373-814e-93ea-75acacfa7b08"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"4", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", "S"}], ",", 
     RowBox[{
      RowBox[{"6", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"6", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"8", " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SqrtBox["3"], " ", 
            SuperscriptBox["c", "2"]}], "+", "S"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"6", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"6", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"8", " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", "S"}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{
         SqrtBox["3"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"4", " ", "S"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SqrtBox["3"], " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{"2", " ", "S"}]}], ",", 
     RowBox[{
      RowBox[{
       SqrtBox["3"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", "S"}]}], ",", 
     RowBox[{
      RowBox[{
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", "S"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.947219938463022*^9, 3.947219953280428*^9}, 
   3.947220072762945*^9, 3.947220587407793*^9, {3.947220742419802*^9, 
   3.947220756389679*^9}, 3.9472209716857247`*^9, {3.947221316903416*^9, 
   3.947221368211802*^9}, 3.947265426945291*^9, {3.947265480018751*^9, 
   3.947265505507498*^9}, 3.947265560009592*^9, 3.947568818402437*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"aff4700f-7083-2544-9d60-c8ed66e4559e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 
  3.9466432738224773`*^9}},ExpressionUUID->"1eb46387-99e7-e846-ae8e-\
e372f71dcd99"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9},
 CellLabel->"In[81]:=",ExpressionUUID->"383272eb-0fe6-c349-b07e-1b22d9f397f0"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, {3.947221320534374*^9, 3.947221370088148*^9}, 
   3.947265430733423*^9, {3.947265482951071*^9, 3.947265508010603*^9}, 
   3.9472655628136635`*^9, 3.947568820639063*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"8bbcb16c-ffc2-5646-8add-0ad9786173be"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (397) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, 
   3.94644557474518*^9, {3.946643253792639*^9, 3.946643284390875*^9}, {
   3.946746036139828*^9, 3.946746038524223*^9}, {3.946746068669115*^9, 
   3.9467460693399773`*^9}, {3.946746103812231*^9, 3.946746104772272*^9}, {
   3.9467461898531*^9, 3.946746192036283*^9}, {3.946746233828554*^9, 
   3.946746236204479*^9}, 3.946748343513323*^9, 3.947219934891445*^9, {
   3.947220580931544*^9, 3.947220580995568*^9}, 3.947220722468012*^9, {
   3.9472209548836827`*^9, 3.947220954915217*^9}, {3.947221312588068*^9, 
   3.947221312651436*^9}, {3.9472653803364296`*^9, 3.94726538040098*^9}, {
   3.947265472225422*^9, 3.9472654978165493`*^9}, {3.9472655698327255`*^9, 
   3.9472655716566734`*^9}},ExpressionUUID->"7b1e9c8e-61e6-2d4a-af2d-\
d8fc6dd29255"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "397", "]"}]}]], "Input",
 CellChangeTimes->{{3.9467442551607094`*^9, 3.946744265127234*^9}, {
   3.947219928684494*^9, 3.9472199377645683`*^9}, {3.9472205865158615`*^9, 
   3.94722058657226*^9}, {3.947220741660054*^9, 3.947220741715954*^9}, {
   3.947220970963372*^9, 3.9472209710436344`*^9}, {3.9472213155392118`*^9, 
   3.947221367523184*^9}, {3.9472653867689705`*^9, 3.947265388568966*^9}, 
   3.947265425760828*^9, {3.947265477513033*^9, 3.947265504664564*^9}, {
   3.947265575768846*^9, 3.947265577249396*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"f4667a65-2056-0e45-92f1-706495650c8f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "-", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "+", 
              RowBox[{
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"]}], "-", 
      SuperscriptBox["b", "6"], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "5"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{"12", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "4"], " ", "S"}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "4"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"4", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "6"]}], "+", 
      SuperscriptBox["b", "6"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{"12", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "4"], " ", "S"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "4"], "-", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "+", 
              RowBox[{
               SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["a", "2"], " ", "S"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["b", "2"], " ", "S"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.947219938463022*^9, 3.947219953280428*^9}, 
   3.947220072762945*^9, 3.947220587407793*^9, {3.947220742419802*^9, 
   3.947220756389679*^9}, 3.9472209716857247`*^9, {3.947221316903416*^9, 
   3.947221368211802*^9}, 3.947265426945291*^9, {3.947265480018751*^9, 
   3.947265505507498*^9}, 3.947265578342467*^9, 3.9475688254117756`*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"fffe48b9-df6f-ce49-913c-59a6cd5265d1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 
  3.9466432738224773`*^9}},ExpressionUUID->"63a876c1-1429-0141-a374-\
3cae4040e874"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9},
 CellLabel->"In[83]:=",ExpressionUUID->"4eb0dfca-6042-7b45-9886-b8611108fbc4"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, {3.947221320534374*^9, 3.947221370088148*^9}, 
   3.947265430733423*^9, {3.947265482951071*^9, 3.947265508010603*^9}, 
   3.9472655800261154`*^9, 3.9475688271215496`*^9},
 CellLabel->"Out[83]=",ExpressionUUID->"23c56ff2-269d-3d43-9262-c4e7ba6f779c"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (398) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, 
   3.94644557474518*^9, {3.946643253792639*^9, 3.946643284390875*^9}, {
   3.946746036139828*^9, 3.946746038524223*^9}, {3.946746068669115*^9, 
   3.9467460693399773`*^9}, {3.946746103812231*^9, 3.946746104772272*^9}, {
   3.9467461898531*^9, 3.946746192036283*^9}, {3.946746233828554*^9, 
   3.946746236204479*^9}, 3.946748343513323*^9, 3.947219934891445*^9, {
   3.947220580931544*^9, 3.947220580995568*^9}, 3.947220722468012*^9, {
   3.9472209548836827`*^9, 3.947220954915217*^9}, {3.947221312588068*^9, 
   3.947221312651436*^9}, {3.9472653803364296`*^9, 3.94726538040098*^9}, {
   3.947265472225422*^9, 3.9472654978165493`*^9}, {3.9472656061207066`*^9, 
   3.947265607408329*^9}},ExpressionUUID->"2f231f2b-d5ac-3942-ba09-\
60e773afe8b3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "398", "]"}]}]], "Input",
 CellChangeTimes->{{3.9467442551607094`*^9, 3.946744265127234*^9}, {
   3.947219928684494*^9, 3.9472199377645683`*^9}, {3.9472205865158615`*^9, 
   3.94722058657226*^9}, {3.947220741660054*^9, 3.947220741715954*^9}, {
   3.947220970963372*^9, 3.9472209710436344`*^9}, {3.9472213155392118`*^9, 
   3.947221367523184*^9}, {3.9472653867689705`*^9, 3.947265388568966*^9}, 
   3.947265425760828*^9, {3.947265477513033*^9, 3.947265504664564*^9}, {
   3.9472655886328754`*^9, 3.9472655973055687`*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"a0e9469d-dfff-724b-8e65-2bf89d3e0f07"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "6"]}], "+", 
      SuperscriptBox["b", "6"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{"12", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "4"], " ", "S"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "4"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"6", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "-", 
            RowBox[{"2", " ", 
             SqrtBox["3"], " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"4", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"]}], "-", 
      SuperscriptBox["b", "6"], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "5"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{"12", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "4"], " ", "S"}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "4"], "+", 
         RowBox[{"2", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"6", " ", 
          SqrtBox["3"], " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", 
          SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"3", " ", 
             SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SqrtBox["3"], " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{
            SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["a", "2"], " ", "S"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["b", "2"], " ", "S"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{"2", " ", 
       SqrtBox["3"], " ", 
       SuperscriptBox["c", "2"], " ", "S"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.947219938463022*^9, 3.947219953280428*^9}, 
   3.947220072762945*^9, 3.947220587407793*^9, {3.947220742419802*^9, 
   3.947220756389679*^9}, 3.9472209716857247`*^9, {3.947221316903416*^9, 
   3.947221368211802*^9}, 3.947265426945291*^9, {3.947265480018751*^9, 
   3.947265505507498*^9}, {3.947265591112345*^9, 3.947265598086058*^9}, 
   3.9475688323467255`*^9},
 CellLabel->"Out[84]=",ExpressionUUID->"67674a7f-d35f-8b45-a988-9669f8512b14"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 
  3.9466432738224773`*^9}},ExpressionUUID->"c6625a86-c58b-9d46-8f93-\
f68119b90ec1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9},
 CellLabel->"In[85]:=",ExpressionUUID->"ea9b26e9-dedc-d54f-b711-731fb9f905ab"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, {3.947221320534374*^9, 3.947221370088148*^9}, 
   3.947265430733423*^9, {3.947265482951071*^9, 3.947265508010603*^9}, {
   3.9472655930654297`*^9, 3.94726559982929*^9}, 3.947568833521961*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"454b2c90-6010-6e40-8fb7-0a4725c0cc68"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (485) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, 
   3.94644557474518*^9, {3.946643253792639*^9, 3.946643284390875*^9}, {
   3.946746036139828*^9, 3.946746038524223*^9}, {3.946746068669115*^9, 
   3.9467460693399773`*^9}, {3.946746103812231*^9, 3.946746104772272*^9}, {
   3.9467461898531*^9, 3.946746192036283*^9}, {3.946746233828554*^9, 
   3.946746236204479*^9}, 3.946748343513323*^9, 3.947219934891445*^9, {
   3.947220580931544*^9, 3.947220580995568*^9}, 3.947220722468012*^9, {
   3.9472209548836827`*^9, 3.947220954915217*^9}, {3.947221312588068*^9, 
   3.947221312651436*^9}, {3.9472653803364296`*^9, 3.94726538040098*^9}, {
   3.947265472225422*^9, 3.9472654978165493`*^9}, {3.947265630129072*^9, 
   3.9472656319447575`*^9}},ExpressionUUID->"ec86b00e-17ad-054d-a95b-\
a9b591916da3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "485", "]"}]}]], "Input",
 CellChangeTimes->{{3.9467442551607094`*^9, 3.946744265127234*^9}, {
   3.947219928684494*^9, 3.9472199377645683`*^9}, {3.9472205865158615`*^9, 
   3.94722058657226*^9}, {3.947220741660054*^9, 3.947220741715954*^9}, {
   3.947220970963372*^9, 3.9472209710436344`*^9}, {3.9472213155392118`*^9, 
   3.947221367523184*^9}, {3.9472653867689705`*^9, 3.947265388568966*^9}, 
   3.947265425760828*^9, {3.947265477513033*^9, 3.947265504664564*^9}, {
   3.947265636265262*^9, 3.947265637432623*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"1f863a1c-acd3-3c4f-8082-73124997df76"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"2", " ", "S"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"]}], "-", 
      SuperscriptBox["b", "6"], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "6"], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "5"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["c", "4"], " ", "S"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["S", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"7", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"], "+", 
             RowBox[{"2", " ", "S"}]}], ")"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"8", " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", "S"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"]}], "-", 
        SuperscriptBox["b", "6"], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "6"], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{"12", " ", 
         SuperscriptBox["c", "4"], " ", "S"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["c", "2"], " ", 
         SuperscriptBox["S", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"7", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "4"], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], 
       ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"]}], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"], "+", 
          RowBox[{"2", " ", "S"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               RowBox[{"2", " ", 
                SuperscriptBox["c", "2"]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"], "+", 
               RowBox[{"2", " ", "S"}]}], ")"}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"8", " ", "S"}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["a", "6"]}], "-", 
      SuperscriptBox["b", "6"], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "6"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "7"}], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["S", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}], "2"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.947219938463022*^9, 3.947219953280428*^9}, 
   3.947220072762945*^9, 3.947220587407793*^9, {3.947220742419802*^9, 
   3.947220756389679*^9}, 3.9472209716857247`*^9, {3.947221316903416*^9, 
   3.947221368211802*^9}, 3.947265426945291*^9, {3.947265480018751*^9, 
   3.947265505507498*^9}, 3.9472656383686237`*^9, 3.947568837507036*^9},
 CellLabel->"Out[86]=",ExpressionUUID->"3d9c0f9e-cd79-ce47-816e-0632de15eae4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 
  3.9466432738224773`*^9}},ExpressionUUID->"7fb5e273-34a3-5a4f-b601-\
6cede1ef2108"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9},
 CellLabel->"In[87]:=",ExpressionUUID->"2e87aa83-cf5e-7742-a2ad-d66e0548f683"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, {3.947221320534374*^9, 3.947221370088148*^9}, 
   3.947265430733423*^9, {3.947265482951071*^9, 3.947265508010603*^9}, 
   3.947265640064195*^9, 3.947568839344303*^9},
 CellLabel->"Out[87]=",ExpressionUUID->"c07a7dca-6cb3-9a48-b4d6-7b2b450f57c2"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (590) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, 
   3.94644557474518*^9, {3.946643253792639*^9, 3.946643284390875*^9}, {
   3.946746036139828*^9, 3.946746038524223*^9}, {3.946746068669115*^9, 
   3.9467460693399773`*^9}, {3.946746103812231*^9, 3.946746104772272*^9}, {
   3.9467461898531*^9, 3.946746192036283*^9}, {3.946746233828554*^9, 
   3.946746236204479*^9}, 3.946748343513323*^9, 3.947219934891445*^9, {
   3.947220580931544*^9, 3.947220580995568*^9}, 3.947220722468012*^9, {
   3.9472209548836827`*^9, 3.947220954915217*^9}, {3.947221312588068*^9, 
   3.947221312651436*^9}, {3.947265380336429*^9, 3.94726538040098*^9}, {
   3.947265472225422*^9, 3.9472654978165493`*^9}, {3.947265630129072*^9, 
   3.947265655841431*^9}},ExpressionUUID->"154d3327-cc52-444f-9ab0-\
ee985f816421"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "590", "]"}]}]], "Input",
 CellChangeTimes->{{3.9467442551607094`*^9, 3.946744265127234*^9}, {
   3.947219928684494*^9, 3.9472199377645683`*^9}, {3.9472205865158615`*^9, 
   3.94722058657226*^9}, {3.947220741660054*^9, 3.947220741715954*^9}, {
   3.947220970963372*^9, 3.9472209710436344`*^9}, {3.9472213155392118`*^9, 
   3.947221367523184*^9}, {3.9472653867689705`*^9, 3.947265388568966*^9}, 
   3.947265425760828*^9, {3.947265477513033*^9, 3.947265504664564*^9}, {
   3.947265636265262*^9, 3.94726566362558*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"095438a3-20b5-a943-84c2-e681e15aca00"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"4", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", "S"}], ",", 
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"8", " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "+", "S"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"8", " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", "S"}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"4", " ", "S"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      RowBox[{"2", " ", "S"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      RowBox[{"2", " ", "S"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      RowBox[{"2", " ", "S"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.947219938463022*^9, 3.947219953280428*^9}, 
   3.947220072762945*^9, 3.947220587407793*^9, {3.947220742419802*^9, 
   3.947220756389679*^9}, 3.9472209716857247`*^9, {3.947221316903416*^9, 
   3.947221368211802*^9}, 3.947265426945291*^9, {3.947265480018751*^9, 
   3.947265505507498*^9}, {3.9472656383686237`*^9, 3.947265664276337*^9}, 
   3.9475688444384594`*^9},
 CellLabel->"Out[88]=",ExpressionUUID->"f92ad227-3a46-474c-b7a4-7a82d2c6187d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 
  3.9466432738224773`*^9}},ExpressionUUID->"d473cf60-826f-6342-8118-\
99f351bb0961"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9},
 CellLabel->"In[89]:=",ExpressionUUID->"a1503fdd-f976-0546-89b1-6782569356ca"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, {3.947221320534374*^9, 3.947221370088148*^9}, 
   3.947265430733423*^9, {3.947265482951071*^9, 3.947265508010603*^9}, {
   3.947265640064195*^9, 3.9472656658185577`*^9}, 3.947568846604044*^9},
 CellLabel->"Out[89]=",ExpressionUUID->"ab94b519-a444-a04c-a2f3-f97cce20bceb"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (615) ", "Subsection",
 CellChangeTimes->{{3.946439666802977*^9, 3.946439670481838*^9}, 
   3.94644557474518*^9, {3.946643253792639*^9, 3.946643284390875*^9}, {
   3.946746036139828*^9, 3.946746038524223*^9}, {3.946746068669115*^9, 
   3.9467460693399773`*^9}, {3.946746103812231*^9, 3.946746104772272*^9}, {
   3.9467461898531*^9, 3.946746192036283*^9}, {3.946746233828554*^9, 
   3.946746236204479*^9}, 3.946748343513323*^9, 3.947219934891445*^9, {
   3.947220580931544*^9, 3.947220580995568*^9}, 3.947220722468012*^9, {
   3.9472209548836827`*^9, 3.947220954915217*^9}, {3.947221312588068*^9, 
   3.947221312651436*^9}, {3.9472653803364296`*^9, 3.94726538040098*^9}, {
   3.947265472225422*^9, 3.9472654978165493`*^9}, {3.947265630129072*^9, 
   3.9472656319447575`*^9}, {3.9472656759766216`*^9, 
   3.9472656766484127`*^9}},ExpressionUUID->"534f7c07-a39b-2e47-adae-\
033ca9706795"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "615", "]"}]}]], "Input",
 CellChangeTimes->{{3.9467442551607094`*^9, 3.946744265127234*^9}, {
   3.947219928684494*^9, 3.9472199377645683`*^9}, {3.9472205865158615`*^9, 
   3.94722058657226*^9}, {3.947220741660054*^9, 3.947220741715954*^9}, {
   3.947220970963372*^9, 3.9472209710436344`*^9}, {3.9472213155392118`*^9, 
   3.947221367523184*^9}, {3.9472653867689705`*^9, 3.947265388568966*^9}, 
   3.947265425760828*^9, {3.947265477513033*^9, 3.947265504664564*^9}, {
   3.947265636265262*^9, 3.947265637432623*^9}, {3.947265682073068*^9, 
   3.947265683377119*^9}},
 CellLabel->"In[90]:=",ExpressionUUID->"a7b789bd-1ae0-f14c-b911-ec3082b90396"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"4", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", "S"}], ",", 
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"8", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", "S"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"8", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", "S"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", "S"}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"4", " ", "S"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{"2", " ", "S"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"2", " ", "S"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], "-", 
      RowBox[{"2", " ", "S"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.947219938463022*^9, 3.947219953280428*^9}, 
   3.947220072762945*^9, 3.947220587407793*^9, {3.947220742419802*^9, 
   3.947220756389679*^9}, 3.9472209716857247`*^9, {3.947221316903416*^9, 
   3.947221368211802*^9}, 3.947265426945291*^9, {3.947265480018751*^9, 
   3.947265505507498*^9}, 3.9472656383686237`*^9, 3.947265684016643*^9, 
   3.94756885151025*^9},
 CellLabel->"Out[90]=",ExpressionUUID->"a4d16b57-6bc3-2d44-946b-b5a1c93d722f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["persp[ABCD,EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466432677056904`*^9, 
  3.9466432738224773`*^9}},ExpressionUUID->"186d9ba8-b98b-e142-bf47-\
0e4ce4f64fd9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"PerspectiveQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
    "]"}], "/.", "sustS"}], "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.94643974580937*^9, 3.946439746776945*^9}, 
   3.946445595193435*^9, {3.946451144473961*^9, 3.946451144536968*^9}, {
   3.9464512240333977`*^9, 3.9464512835614243`*^9}, {3.946453515222332*^9, 
   3.946453516550245*^9}, {3.9466433242708*^9, 3.946643325367031*^9}, {
   3.9467334464377155`*^9, 3.946733470254036*^9}, {3.946733583677754*^9, 
   3.946733611725321*^9}, 3.946743029960489*^9, 3.946744125174686*^9, {
   3.946745024798212*^9, 3.94674503909321*^9}, {3.946745964437242*^9, 
   3.946745975220922*^9}, 3.9467471123071976`*^9, 3.946748048593914*^9, 
   3.947219925477543*^9, 3.9472199591882153`*^9, {3.94722076383597*^9, 
   3.947220805203724*^9}, 3.9472208396362553`*^9, {3.947568867384886*^9, 
   3.94756887369689*^9}},ExpressionUUID->"6e6b4fa3-d593-d949-ad53-\
5c5b5cbccfed"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9467336128094845`*^9, 3.946734436506981*^9, 3.946738450367491*^9, 
   3.9467385084196877`*^9, 3.9467385559578857`*^9, 3.946738717706724*^9, 
   3.946743031131069*^9, 3.946744126317896*^9, 3.9467442703389072`*^9, 
   3.9467447056420097`*^9, {3.946745027041918*^9, 3.946745040177214*^9}, 
   3.946745586620676*^9, {3.946745969079975*^9, 3.946745975821544*^9}, 
   3.946746609472439*^9, 3.946746756270243*^9, {3.9467471129501934`*^9, 
   3.946747140038519*^9}, 3.946748049697641*^9, 3.94721996000634*^9, {
   3.947220068470625*^9, 3.947220075305727*^9}, 3.947220591628313*^9, {
   3.947220744366961*^9, 3.9472208065440006`*^9}, 3.947220842349869*^9, 
   3.947220975500773*^9, {3.947221320534374*^9, 3.947221370088148*^9}, 
   3.947265430733423*^9, {3.947265482951071*^9, 3.947265508010603*^9}, 
   3.947265640064195*^9, 3.9472656856914425`*^9, 3.9475688539783516`*^9},
 CellLabel->"Out[91]=",ExpressionUUID->"131d0d26-f293-d340-a9bf-c107f522ba3d"]
}, Closed]]
}, Closed]]
},
CellGrouping->Manual,
WindowSize->{1293.2830188679245`, 654.7924528301886},
WindowMargins->{{0, Automatic}, {Automatic, -0.6792452830188679}},
FrontEndVersion->"14.0 for Microsoft Windows (64-bit) (December 12, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"d321a292-60ab-c548-aa39-b32856a28d81"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 293, 5, 98, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[854, 27, 1410, 24, 173, "Text",ExpressionUUID->"08758b0a-705f-b842-b1d6-6a28a79b6218"],
Cell[CellGroupData[{
Cell[2289, 55, 200, 4, 67, "Section",ExpressionUUID->"5e4c6aa2-710c-4599-941e-5f13e499af78"],
Cell[CellGroupData[{
Cell[2514, 63, 1505, 32, 67, "Input",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"],
Cell[4022, 97, 445, 12, 35, "Output",ExpressionUUID->"42c15b27-92d0-4942-aecd-b7dd69cf0375"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4504, 114, 503, 13, 28, "Input",ExpressionUUID->"99b2e229-dd1e-9847-93a3-8109a1361668"],
Cell[5010, 129, 837, 23, 35, "Output",ExpressionUUID->"01536e20-67b0-d643-8c30-057499f5e6db"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5884, 157, 967, 29, 31, "Input",ExpressionUUID->"a61c9d71-2293-2546-a38b-c7fff8eb7467"],
Cell[6854, 188, 346, 5, 32, "Output",ExpressionUUID->"82f4d30f-3642-2a44-9093-4235a98ff281"]
}, Open  ]],
Cell[7215, 196, 1076, 29, 48, "Input",ExpressionUUID->"7ed74a17-e41b-bd47-b883-c0a2d1fa3802"]
}, Closed]],
Cell[CellGroupData[{
Cell[8328, 230, 255, 4, 53, "Section",ExpressionUUID->"cf60f297-bbcd-8748-b453-e7118b4e0a98"],
Cell[CellGroupData[{
Cell[8608, 238, 212, 4, 54, "Subsection",ExpressionUUID->"c8cca55e-04f1-8f4a-b670-3c3179eed91e"],
Cell[8823, 244, 271222, 7062, 3643, "Input",ExpressionUUID->"90297db1-2eea-6346-9338-a3e8dcfe0024"]
}, Closed]],
Cell[CellGroupData[{
Cell[280082, 7311, 215, 4, 38, "Subsection",ExpressionUUID->"79ef6085-3de7-3c49-8561-f943fbd2d431"],
Cell[280300, 7317, 433, 11, 28, "Input",ExpressionUUID->"e725b315-4161-274c-8798-a4e0c807d6a8"],
Cell[280736, 7330, 435, 11, 28, "Input",ExpressionUUID->"60fea3de-a36e-734d-b67f-75eab8f36838"],
Cell[281174, 7343, 434, 11, 28, "Input",ExpressionUUID->"422bd8e2-a85e-d748-b542-6c9b62c11efd"],
Cell[281611, 7356, 1078, 29, 28, "Input",ExpressionUUID->"d021f1ab-c58d-b74b-8aa5-a62365464cc5"],
Cell[282692, 7387, 816, 23, 28, "Input",ExpressionUUID->"023d4850-e194-b941-a762-4c9a532e11d1"],
Cell[283511, 7412, 599, 16, 28, "Input",ExpressionUUID->"62ef2468-c328-714d-8bf7-299b142a086d"],
Cell[284113, 7430, 2069, 53, 181, "Input",ExpressionUUID->"d734f707-6812-364b-b359-ac3a6bb66e72"],
Cell[286185, 7485, 1710, 46, 143, "Input",ExpressionUUID->"34f7e383-98aa-bc47-9867-166186424dd4"],
Cell[287898, 7533, 1910, 50, 162, "Input",ExpressionUUID->"4370c731-693f-a941-82c8-1f6a14f724b2"],
Cell[289811, 7585, 609, 16, 28, "Input",ExpressionUUID->"6e2024d9-4541-ea4e-a308-49a8bb9b87a5"],
Cell[290423, 7603, 1127, 29, 124, "Input",ExpressionUUID->"384fc915-4ebd-5342-9174-a166a5e7f52d"],
Cell[291553, 7634, 1391, 39, 124, "Input",ExpressionUUID->"e878baba-ea71-dd4f-b972-2e4c3753c774"],
Cell[292947, 7675, 1394, 39, 124, "Input",ExpressionUUID->"4200ee2b-abeb-b246-85fa-68f1ce5d836b"],
Cell[294344, 7716, 1326, 38, 124, "Input",ExpressionUUID->"8131db8a-5012-e741-93f3-ec6da52923f1"],
Cell[295673, 7756, 1364, 37, 143, "Input",ExpressionUUID->"3e5eb206-464c-7e4f-b628-98c50c5a4629"]
}, Closed]],
Cell[CellGroupData[{
Cell[297074, 7798, 291, 5, 38, "Subsection",ExpressionUUID->"d004e03f-8f12-9a43-865f-339812029417"],
Cell[297368, 7805, 3314, 100, 130, "Input",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],
Cell[CellGroupData[{
Cell[300719, 7910, 170, 3, 38, "Subsection",ExpressionUUID->"2a49be25-3c4e-430e-86c6-869880736f30"],
Cell[CellGroupData[{
Cell[300914, 7917, 217, 4, 45, "Subsubsection",ExpressionUUID->"a576f9af-1f5b-4213-b4d3-e7b66981337e"],
Cell[301134, 7923, 53880, 889, 404, "Text",ExpressionUUID->"f7950398-57cb-4ee6-bf14-597b39eb91df"],
Cell[355017, 8814, 995, 24, 86, "Input",ExpressionUUID->"cf738f77-0d96-4e62-81a0-f2a504594dc8"]
}, Closed]],
Cell[CellGroupData[{
Cell[356049, 8843, 238, 4, 37, "Subsubsection",ExpressionUUID->"f7957972-a4e9-446f-bafd-6774f0dd3699"],
Cell[356290, 8849, 813, 18, 48, "Input",ExpressionUUID->"44de57fd-6e7d-4d98-94a0-c7b93947eadd"]
}, Closed]],
Cell[CellGroupData[{
Cell[357140, 8872, 215, 4, 37, "Subsubsection",ExpressionUUID->"ae32c2db-9871-344f-aabd-a2543db56100"],
Cell[357358, 8878, 2072, 56, 101, "Input",ExpressionUUID->"db0fcba9-9144-4df7-981b-db22bb466a6e"]
}, Closed]],
Cell[CellGroupData[{
Cell[359467, 8939, 242, 4, 37, "Subsubsection",ExpressionUUID->"29f12ada-9fd0-4747-b323-2cf96d6fb52e"],
Cell[359712, 8945, 660, 15, 28, "Input",ExpressionUUID->"158fb412-c771-43ab-b43b-a357380f4a11"]
}, Closed]],
Cell[CellGroupData[{
Cell[360409, 8965, 197, 3, 37, "Subsubsection",ExpressionUUID->"5a543829-5641-9144-8dd0-57eb7cf1938d"],
Cell[360609, 8970, 1563, 42, 124, "Input",ExpressionUUID->"35cb8ff3-829e-654a-a95d-e2c972de6be9"]
}, Closed]],
Cell[CellGroupData[{
Cell[362209, 9017, 174, 3, 37, "Subsubsection",ExpressionUUID->"e039afe9-d89d-4ec4-94b9-ddb3f9f259e0"],
Cell[362386, 9022, 558, 14, 28, "Input",ExpressionUUID->"2db3c5dc-e4da-4371-937a-22cb108c81e1"]
}, Closed]],
Cell[CellGroupData[{
Cell[362981, 9041, 372, 6, 37, "Subsubsection",ExpressionUUID->"bd16b166-d506-5544-b5d0-7aa6edfca35b"],
Cell[363356, 9049, 1243, 33, 52, "Input",ExpressionUUID->"6cd12b17-ccf6-1f40-8216-e746f72a898c"]
}, Closed]],
Cell[CellGroupData[{
Cell[364636, 9087, 384, 6, 37, "Subsubsection",ExpressionUUID->"d546f79d-5ed9-4f99-846e-3ac1a3756b86"],
Cell[365023, 9095, 968, 26, 28, "Input",ExpressionUUID->"5668c7c2-b2f3-48b4-bb4e-3f493e46ab9c"],
Cell[365994, 9123, 879, 24, 28, "Input",ExpressionUUID->"d07dfa48-d9b6-433c-9d4d-8f2532f1bec3"]
}, Closed]],
Cell[CellGroupData[{
Cell[366910, 9152, 323, 5, 37, "Subsubsection",ExpressionUUID->"8f461d45-0647-c84b-9fe0-f72d3601c63f"],
Cell[367236, 9159, 1682, 40, 157, "Input",ExpressionUUID->"5485ed32-34f6-e64e-bd2a-b4e163c2b97f"]
}, Closed]],
Cell[CellGroupData[{
Cell[368955, 9204, 201, 3, 37, "Subsubsection",ExpressionUUID->"54169a90-c35c-7a4a-a37f-78c9753e8eeb"],
Cell[369159, 9209, 1627, 39, 124, "Input",ExpressionUUID->"c1bc4c8d-1ecd-654a-b9e2-f902b4037dfa"]
}, Closed]],
Cell[CellGroupData[{
Cell[370823, 9253, 225, 4, 37, "Subsubsection",ExpressionUUID->"e126572d-bdab-a047-b925-c2661290f09e"],
Cell[371051, 9259, 1438, 37, 105, "Input",ExpressionUUID->"3eac6f83-9820-5d4f-9acd-4f2df1b13510"]
}, Closed]],
Cell[CellGroupData[{
Cell[372526, 9301, 308, 5, 37, "Subsubsection",ExpressionUUID->"1d12da59-37f1-9842-ad9c-eb916041816f"],
Cell[372837, 9308, 3086, 70, 219, "Input",ExpressionUUID->"806c98e7-c027-de46-8fc2-cc2eda959f64"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[375972, 9384, 228, 4, 38, "Subsection",ExpressionUUID->"40e5692f-48f3-024d-af81-1a5914b0813b"],
Cell[CellGroupData[{
Cell[376225, 9392, 290, 4, 37, "Subsubsection",ExpressionUUID->"9332bfd4-b794-9542-bea9-284a11b178c6"],
Cell[376518, 9398, 699, 14, 31, "Input",ExpressionUUID->"5bc10ce3-9329-a946-86e7-d45107084797"]
}, Closed]],
Cell[CellGroupData[{
Cell[377254, 9417, 238, 4, 37, "Subsubsection",ExpressionUUID->"4a989280-28db-ca4e-bb0b-101f688af051"],
Cell[377495, 9423, 70990, 1166, 534, "Text",ExpressionUUID->"113413b2-0b67-2b41-9e95-6ce395a68d94"],
Cell[448488, 10591, 386, 8, 31, "Input",ExpressionUUID->"80d07db2-b412-a249-8575-62ea6579cc8c"],
Cell[CellGroupData[{
Cell[448899, 10603, 626, 15, 31, "Input",ExpressionUUID->"77841308-7f6b-cd46-a7ee-3ab0abd88dc2"],
Cell[449528, 10620, 598, 8, 70, "Output",ExpressionUUID->"064119d9-7da6-8740-bc4f-13ac24a9e10f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[450163, 10633, 625, 15, 31, "Input",ExpressionUUID->"50b1474a-8391-ca4a-aad2-5206c808fb4f"],
Cell[450791, 10650, 575, 8, 70, "Output",ExpressionUUID->"9455086c-f72f-5f43-a354-f7e829955352"]
}, Open  ]],
Cell[451381, 10661, 690, 16, 31, "Input",ExpressionUUID->"448ea2bb-3258-a841-a2d3-d7177e41cebf"]
}, Closed]],
Cell[CellGroupData[{
Cell[452108, 10682, 286, 4, 37, "Subsubsection",ExpressionUUID->"6221cf63-919d-e141-8412-466cad561c91"],
Cell[452397, 10688, 36923, 609, 221, "Text",ExpressionUUID->"56df0d81-b84a-0a40-8935-622d3a9520bb"],
Cell[489323, 11299, 437, 9, 31, "Input",ExpressionUUID->"2a84e9eb-3b52-7d4c-8269-c5737e1783b0"],
Cell[CellGroupData[{
Cell[489785, 11312, 458, 11, 31, "Input",ExpressionUUID->"c59ea1e9-aaa1-ba42-8ac2-a180175f33d0"],
Cell[490246, 11325, 552, 8, 70, "Output",ExpressionUUID->"defac836-d0fd-5d46-b0dc-913474e2b60d"]
}, Open  ]],
Cell[490813, 11336, 1539, 38, 94, "Input",ExpressionUUID->"58f5683c-eea5-5f4d-908b-138ff9f5786b"]
}, Closed]],
Cell[CellGroupData[{
Cell[492389, 11379, 333, 5, 37, "Subsubsection",ExpressionUUID->"27f808e6-e579-8044-bb27-905ebef0af91"],
Cell[492725, 11386, 23882, 394, 180, "Text",ExpressionUUID->"b9f0a34c-bb41-5b40-8075-20f44c1ed2ab"],
Cell[516610, 11782, 483, 9, 31, "Input",ExpressionUUID->"289e036b-59cc-294d-8968-9f3882987b07"],
Cell[CellGroupData[{
Cell[517118, 11795, 458, 11, 31, "Input",ExpressionUUID->"5cb44932-662b-c34f-9d5e-9a4f33e7d9e5"],
Cell[517579, 11808, 575, 8, 70, "Output",ExpressionUUID->"f9e61ab7-be83-e74f-be8c-74d80405ac99"]
}, Open  ]],
Cell[518169, 11819, 1295, 35, 94, "Input",ExpressionUUID->"b3d30327-18b8-3e47-8ce7-7916c293687d"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[519525, 11861, 211, 4, 53, "Section",ExpressionUUID->"2609bf4c-7f5c-314e-a744-f86d4be283dd"],
Cell[519739, 11867, 42963, 710, 154, "Text",ExpressionUUID->"a9801838-6d70-da40-ac1d-2346a29fb1bd"],
Cell[CellGroupData[{
Cell[562727, 12581, 517, 8, 54, "Subsection",ExpressionUUID->"e85933b6-4979-c24d-aa11-99cf73704e81"],
Cell[CellGroupData[{
Cell[563269, 12593, 370, 7, 28, "Input",ExpressionUUID->"0ba1376c-1520-5a4c-92b5-5db6faad1da1"],
Cell[563642, 12602, 13278, 416, 188, "Output",ExpressionUUID->"ee4c567f-60b8-4c46-a1f0-0ddef31d73a1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[576957, 13023, 171, 3, 45, "Subsubsection",ExpressionUUID->"b6799f86-6664-094c-99ef-79afc8a62910"],
Cell[CellGroupData[{
Cell[577153, 13030, 950, 17, 28, "Input",ExpressionUUID->"55610e76-6e5b-a147-ba83-256232cf290c"],
Cell[578106, 13049, 707, 10, 32, "Output",ExpressionUUID->"39604896-c41b-874d-9443-bdeccd4a5598"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[578874, 13066, 571, 9, 38, "Subsection",ExpressionUUID->"0817d928-21c0-2845-8bc9-11a79fcf7f45"],
Cell[CellGroupData[{
Cell[579470, 13079, 420, 8, 28, "Input",ExpressionUUID->"b783a433-965a-4e44-bdf0-c24b51868404"],
Cell[579893, 13089, 13312, 417, 188, "Output",ExpressionUUID->"83d2b2b4-4f26-d348-ae18-de074e52562b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[593242, 13511, 171, 3, 45, "Subsubsection",ExpressionUUID->"8bd983c8-b773-1446-8c58-9d9fce10c308"],
Cell[CellGroupData[{
Cell[593438, 13518, 950, 17, 28, "Input",ExpressionUUID->"57ac7a59-b5a6-b042-9bee-e346db8eefb2"],
Cell[594391, 13537, 734, 11, 32, "Output",ExpressionUUID->"d0810914-900d-9e4c-bdb3-f899a091084b"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[595186, 13555, 593, 9, 38, "Subsection",ExpressionUUID->"bf08d3da-6bfe-9647-8de8-2b79433fe19f"],
Cell[CellGroupData[{
Cell[595804, 13568, 466, 8, 28, "Input",ExpressionUUID->"8d50bc02-97be-9d41-8717-230ffa943103"],
Cell[596273, 13578, 10343, 320, 145, "Output",ExpressionUUID->"bd793a2d-29e3-614b-b737-b2d87e8f0a93"]
}, Open  ]],
Cell[CellGroupData[{
Cell[606653, 13903, 171, 3, 45, "Subsubsection",ExpressionUUID->"1a156b53-dc8b-ec46-aaa3-1997f9eb6785"],
Cell[CellGroupData[{
Cell[606849, 13910, 1133, 21, 28, "Input",ExpressionUUID->"8ce40a0f-1452-2b4e-94f9-f1e848ae41f4"],
Cell[607985, 13933, 808, 12, 32, "Output",ExpressionUUID->"5f3b6cf4-27a0-9247-aa03-5f35c425f9cc"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[608842, 13951, 220, 4, 45, "Subsubsection",ExpressionUUID->"3212cb03-0fa5-5c43-8c48-7c6bab515b27"],
Cell[CellGroupData[{
Cell[609087, 13959, 1187, 22, 28, "Input",ExpressionUUID->"403ab7d2-c6a3-ec41-95d8-eb208af613be"],
Cell[610277, 13983, 810, 12, 32, "Output",ExpressionUUID->"e2f7caa1-39fc-8f4d-a004-05528091dcdf"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[611148, 14002, 647, 10, 38, "Subsection",ExpressionUUID->"7b9d6f3b-edce-994b-905a-fe733968e43d"],
Cell[CellGroupData[{
Cell[611820, 14016, 517, 9, 28, "Input",ExpressionUUID->"0b615984-8d76-e749-b6c1-28e6585f62eb"],
Cell[612340, 14027, 10550, 327, 145, "Output",ExpressionUUID->"262744dd-a654-204c-8246-3f79bff2460e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[622927, 14359, 222, 4, 45, "Subsubsection",ExpressionUUID->"c80de68b-6810-4a48-bafb-64f5299a3bd3"],
Cell[CellGroupData[{
Cell[623174, 14367, 1182, 22, 28, "Input",ExpressionUUID->"2385d125-7233-7543-9a7d-a65a325ddeda"],
Cell[624359, 14391, 882, 13, 32, "Output",ExpressionUUID->"033eb9cf-0828-c143-a8a5-c9219f5c9fc8"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[625290, 14410, 171, 3, 45, "Subsubsection",ExpressionUUID->"964972f7-4b04-8a4b-b149-e0a5e2581a75"],
Cell[CellGroupData[{
Cell[625486, 14417, 1133, 21, 28, "Input",ExpressionUUID->"2dc9c00a-3225-c246-b918-0472d60b11ad"],
Cell[626622, 14440, 856, 12, 32, "Output",ExpressionUUID->"6339bb75-8652-b341-b6ef-d901938460ea"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[627539, 14459, 693, 10, 38, "Subsection",ExpressionUUID->"0771c1cb-44c9-b54d-98e6-001ad32ebc50"],
Cell[CellGroupData[{
Cell[628257, 14473, 618, 10, 28, "Input",ExpressionUUID->"88775239-2fee-c843-9a7f-8398f299b60f"],
Cell[628878, 14485, 38279, 1135, 514, "Output",ExpressionUUID->"dad3e87c-ab21-7544-b7c5-96dd2e0b4d9d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[667194, 15625, 171, 3, 45, "Subsubsection",ExpressionUUID->"0bd7089a-d088-e945-9a0b-5a99effe3815"],
Cell[CellGroupData[{
Cell[667390, 15632, 1133, 21, 28, "Input",ExpressionUUID->"59ad04e9-8d9b-1d4b-a233-463fc1cd65b9"],
Cell[668526, 15655, 904, 13, 32, "Output",ExpressionUUID->"8faabeb2-977b-d44c-9dfa-527f8d9456a2"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[669491, 15675, 738, 11, 38, "Subsection",ExpressionUUID->"dd3e2713-095d-5549-a63d-dc48bfff3c58"],
Cell[CellGroupData[{
Cell[670254, 15690, 646, 11, 28, "Input",ExpressionUUID->"ce24270c-cc23-3a43-b17d-2194b46daa3a"],
Cell[670903, 15703, 38000, 1133, 535, "Output",ExpressionUUID->"bb43c62c-1543-4e4d-a26e-ab4a0535f9f1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[708940, 16841, 171, 3, 45, "Subsubsection",ExpressionUUID->"cab71017-c4a1-024f-a1c6-bcf6549a3a86"],
Cell[CellGroupData[{
Cell[709136, 16848, 1133, 21, 28, "Input",ExpressionUUID->"40898263-cf38-554e-a46a-da43befd8d0e"],
Cell[710272, 16871, 904, 13, 32, "Output",ExpressionUUID->"391004d2-6a80-1144-bea7-0dfaec91156b"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[711237, 16891, 792, 12, 38, "Subsection",ExpressionUUID->"96736451-1f3d-a348-bbb8-89151889b696"],
Cell[CellGroupData[{
Cell[712054, 16907, 694, 11, 28, "Input",ExpressionUUID->"ef5af8d3-6c93-0743-80ce-95afb42eabc9"],
Cell[712751, 16920, 11540, 354, 145, "Output",ExpressionUUID->"62292834-e61f-6f4b-aba6-3cc05b5b0cbd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[724328, 17279, 171, 3, 45, "Subsubsection",ExpressionUUID->"bbb78902-ed6c-5442-8464-462883d5a0a9"],
Cell[CellGroupData[{
Cell[724524, 17286, 1133, 21, 28, "Input",ExpressionUUID->"f69449a8-a60b-a74c-8da1-7a2f799dfa88"],
Cell[725660, 17309, 925, 13, 32, "Output",ExpressionUUID->"9bde4b31-a9d0-9c43-b8dd-2c9c1834f1a6"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[726634, 17328, 222, 4, 45, "Subsubsection",ExpressionUUID->"a15e7bc5-acf7-0e44-b205-0db0079ec5a4"],
Cell[CellGroupData[{
Cell[726881, 17336, 1185, 22, 28, "Input",ExpressionUUID->"ff0464f4-595a-6a41-b22f-6092aaf29bde"],
Cell[728069, 17360, 951, 14, 32, "Output",ExpressionUUID->"e77cbaec-a850-044f-a661-86c3dfc68461"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[729081, 17381, 790, 12, 38, "Subsection",ExpressionUUID->"1a13ed80-5b8b-2945-9a6a-513533df2585"],
Cell[CellGroupData[{
Cell[729896, 17397, 692, 11, 28, "Input",ExpressionUUID->"29194881-88da-744f-badb-03ee5846f760"],
Cell[730591, 17410, 11631, 358, 145, "Output",ExpressionUUID->"a97d50e9-8d29-5a4b-8291-cd67d7094977"]
}, Open  ]],
Cell[CellGroupData[{
Cell[742259, 17773, 171, 3, 45, "Subsubsection",ExpressionUUID->"ba7b1b8a-d2c5-8d4f-be3c-7a80e169f4cc"],
Cell[CellGroupData[{
Cell[742455, 17780, 1133, 21, 28, "Input",ExpressionUUID->"388070c6-65cc-f648-8028-5677491106df"],
Cell[743591, 17803, 952, 14, 32, "Output",ExpressionUUID->"00afaa05-4c09-ae4d-bda4-0e8a929f0412"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[744592, 17823, 221, 4, 45, "Subsubsection",ExpressionUUID->"ef029af8-ff8e-cf49-9c11-0bb0848a4b5c"],
Cell[CellGroupData[{
Cell[744838, 17831, 1183, 22, 28, "Input",ExpressionUUID->"e0c70e38-fd2b-4444-90e8-5bbe598d3dfc"],
Cell[746024, 17855, 952, 14, 32, "Output",ExpressionUUID->"1a536f67-1681-3e4d-a35c-17421dfde84e"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[747037, 17876, 791, 12, 38, "Subsection",ExpressionUUID->"3c4edcb1-85a4-384d-8207-13cca9b10ca6"],
Cell[CellGroupData[{
Cell[747853, 17892, 693, 11, 28, "Input",ExpressionUUID->"dfb497bd-670d-2a42-857a-b14152fcc539"],
Cell[748549, 17905, 4042, 126, 57, "Output",ExpressionUUID->"cb6c1a04-4607-3046-96cc-6486cd414f5a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[752628, 18036, 171, 3, 45, "Subsubsection",ExpressionUUID->"3ded466f-a874-0446-aa27-423e453e179f"],
Cell[CellGroupData[{
Cell[752824, 18043, 1133, 21, 28, "Input",ExpressionUUID->"2c166ff1-8cff-d54a-98ef-75e1774a2718"],
Cell[753960, 18066, 976, 14, 32, "Output",ExpressionUUID->"d94f0fce-e1f4-0d47-ba6c-b0a578ad3c43"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[754985, 18086, 224, 4, 45, "Subsubsection",ExpressionUUID->"c548776f-e5b8-5447-b31a-12fbcac20cc1"],
Cell[CellGroupData[{
Cell[755234, 18094, 1182, 22, 28, "Input",ExpressionUUID->"5e4c3c15-a269-0f43-9814-5100bc2199d2"],
Cell[756419, 18118, 976, 14, 32, "Output",ExpressionUUID->"9f447abc-c912-3144-96cb-a5c5df3e9047"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[757456, 18139, 791, 12, 38, "Subsection",ExpressionUUID->"1cc95522-848b-c547-8511-97120e418ea3"],
Cell[CellGroupData[{
Cell[758272, 18155, 693, 11, 28, "Input",ExpressionUUID->"6aff5b5e-3bb5-464f-9a0d-97f513a11f05"],
Cell[758968, 18168, 3866, 118, 57, "Output",ExpressionUUID->"2bc4b71f-5f68-3b40-a056-cb295b4c706d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[762871, 18291, 171, 3, 45, "Subsubsection",ExpressionUUID->"f9f5dbc7-7b4e-394d-b030-151df7dd0c17"],
Cell[CellGroupData[{
Cell[763067, 18298, 1133, 21, 28, "Input",ExpressionUUID->"4df08a76-a241-884f-902f-046c49002940"],
Cell[764203, 18321, 974, 14, 32, "Output",ExpressionUUID->"aa8dbc00-acfd-3b44-bc50-b70a43abf83d"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[765226, 18341, 220, 4, 45, "Subsubsection",ExpressionUUID->"3f9f5e3d-248e-364d-8690-ac6aa2a2b1d5"],
Cell[CellGroupData[{
Cell[765471, 18349, 1187, 22, 28, "Input",ExpressionUUID->"c937897d-8a74-c941-8eb3-13d20b252476"],
Cell[766661, 18373, 974, 14, 32, "Output",ExpressionUUID->"56fb7123-0ccb-ab42-92a4-4aef5c5a1ad9"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[767696, 18394, 841, 12, 38, "Subsection",ExpressionUUID->"943f594d-0a92-9245-93b9-c77dfa7c65ea"],
Cell[CellGroupData[{
Cell[768562, 18410, 747, 12, 28, "Input",ExpressionUUID->"c8870c0d-0cad-bb42-9b32-951d517f0a87"],
Cell[769312, 18424, 5556, 178, 79, "Output",ExpressionUUID->"eec0756f-3b2a-d242-a958-04fe18a20ff7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[774905, 18607, 171, 3, 45, "Subsubsection",ExpressionUUID->"21c20a9a-5b4e-0149-b217-9448c9719f75"],
Cell[CellGroupData[{
Cell[775101, 18614, 1133, 21, 28, "Input",ExpressionUUID->"917b9a8d-aabf-8448-b7e6-364990783941"],
Cell[776237, 18637, 976, 14, 32, "Output",ExpressionUUID->"e957f1fb-a8a9-9840-b2c1-127d54983578"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[777274, 18658, 837, 12, 38, "Subsection",ExpressionUUID->"7ac133ce-b73f-054c-8461-bcf4bf40478a"],
Cell[CellGroupData[{
Cell[778136, 18674, 743, 12, 28, "Input",ExpressionUUID->"763159cc-f373-814e-93ea-75acacfa7b08"],
Cell[778882, 18688, 5510, 176, 79, "Output",ExpressionUUID->"aff4700f-7083-2544-9d60-c8ed66e4559e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[784429, 18869, 171, 3, 45, "Subsubsection",ExpressionUUID->"1eb46387-99e7-e846-ae8e-e372f71dcd99"],
Cell[CellGroupData[{
Cell[784625, 18876, 1133, 21, 28, "Input",ExpressionUUID->"383272eb-0fe6-c349-b07e-1b22d9f397f0"],
Cell[785761, 18899, 976, 14, 32, "Output",ExpressionUUID->"8bbcb16c-ffc2-5646-8add-0ad9786173be"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[786798, 18920, 841, 12, 38, "Subsection",ExpressionUUID->"7b1e9c8e-61e6-2d4a-af2d-d8fc6dd29255"],
Cell[CellGroupData[{
Cell[787664, 18936, 743, 12, 28, "Input",ExpressionUUID->"f4667a65-2056-0e45-92f1-706495650c8f"],
Cell[788410, 18950, 11075, 342, 145, "Output",ExpressionUUID->"fffe48b9-df6f-ce49-913c-59a6cd5265d1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[799522, 19297, 171, 3, 45, "Subsubsection",ExpressionUUID->"63a876c1-1429-0141-a374-3cae4040e874"],
Cell[CellGroupData[{
Cell[799718, 19304, 1133, 21, 28, "Input",ExpressionUUID->"4eb0dfca-6042-7b45-9886-b8611108fbc4"],
Cell[800854, 19327, 978, 14, 32, "Output",ExpressionUUID->"23c56ff2-269d-3d43-9262-c4e7ba6f779c"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[801893, 19348, 839, 12, 38, "Subsection",ExpressionUUID->"2f231f2b-d5ac-3942-ba09-60e773afe8b3"],
Cell[CellGroupData[{
Cell[802757, 19364, 747, 12, 28, "Input",ExpressionUUID->"a0e9469d-dfff-724b-8e65-2bf89d3e0f07"],
Cell[803507, 19378, 10824, 331, 145, "Output",ExpressionUUID->"67674a7f-d35f-8b45-a988-9669f8512b14"]
}, Open  ]],
Cell[CellGroupData[{
Cell[814368, 19714, 171, 3, 45, "Subsubsection",ExpressionUUID->"c6625a86-c58b-9d46-8f93-f68119b90ec1"],
Cell[CellGroupData[{
Cell[814564, 19721, 1133, 21, 28, "Input",ExpressionUUID->"ea9b26e9-dedc-d54f-b711-731fb9f905ab"],
Cell[815700, 19744, 999, 14, 32, "Output",ExpressionUUID->"454b2c90-6010-6e40-8fb7-0a4725c0cc68"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[816760, 19765, 839, 12, 38, "Subsection",ExpressionUUID->"ec86b00e-17ad-054d-a95b-a9b591916da3"],
Cell[CellGroupData[{
Cell[817624, 19781, 743, 12, 28, "Input",ExpressionUUID->"1f863a1c-acd3-3c4f-8082-73124997df76"],
Cell[818370, 19795, 10553, 322, 143, "Output",ExpressionUUID->"3d9c0f9e-cd79-ce47-816e-0632de15eae4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[828960, 20122, 171, 3, 45, "Subsubsection",ExpressionUUID->"7fb5e273-34a3-5a4f-b601-6cede1ef2108"],
Cell[CellGroupData[{
Cell[829156, 20129, 1133, 21, 28, "Input",ExpressionUUID->"2e87aa83-cf5e-7742-a2ad-d66e0548f683"],
Cell[830292, 20152, 974, 14, 32, "Output",ExpressionUUID->"c07a7dca-6cb3-9a48-b4d6-7b2b450f57c2"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[831327, 20173, 835, 12, 38, "Subsection",ExpressionUUID->"154d3327-cc52-444f-9ab0-ee985f816421"],
Cell[CellGroupData[{
Cell[832187, 20189, 742, 12, 28, "Input",ExpressionUUID->"095438a3-20b5-a943-84c2-e681e15aca00"],
Cell[832932, 20203, 4712, 146, 78, "Output",ExpressionUUID->"f92ad227-3a46-474c-b7a4-7a82d2c6187d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[837681, 20354, 171, 3, 45, "Subsubsection",ExpressionUUID->"d473cf60-826f-6342-8118-99f351bb0961"],
Cell[CellGroupData[{
Cell[837877, 20361, 1133, 21, 28, "Input",ExpressionUUID->"a1503fdd-f976-0546-89b1-6782569356ca"],
Cell[839013, 20384, 1000, 14, 32, "Output",ExpressionUUID->"ab94b519-a444-a04c-a2f3-f97cce20bceb"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[840074, 20405, 893, 13, 38, "Subsection",ExpressionUUID->"534f7c07-a39b-2e47-adae-033ca9706795"],
Cell[CellGroupData[{
Cell[840992, 20422, 793, 13, 28, "Input",ExpressionUUID->"a7b789bd-1ae0-f14c-b911-ec3082b90396"],
Cell[841788, 20437, 4779, 149, 78, "Output",ExpressionUUID->"a4d16b57-6bc3-2d44-946b-b5a1c93d722f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[846604, 20591, 171, 3, 45, "Subsubsection",ExpressionUUID->"186d9ba8-b98b-e142-bf47-0e4ce4f64fd9"],
Cell[846778, 20596, 1160, 22, 28, "Input",ExpressionUUID->"6e6b4fa3-d593-d949-ad53-5c5b5cbccfed"]
}, Open  ]],
Cell[847953, 20621, 1000, 14, 32, "Output",ExpressionUUID->"131d0d26-f293-d340-a9bf-c107f522ba3d"]
}, Closed]]
}, Closed]]
}
]
*)

